package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.event.data.ShipAttackEvent;
import ch.sahits.game.openpatrician.event.data.ShipDefenseEvent;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.Collections;
import java.util.List;

/**
 * Engine to handle the reputation changes.
 */
@Lazy
@Service
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@DependentInitialisation(StartNewGameBean.class)
public class ReputationEngine extends AbstractEngine {
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private SeaPiratesState piratesState;
    @Autowired
    private IMap map;
    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }
    @PostConstruct
    private void initialize() {
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void destroy() {
        clientServerEventBus.unregister(this);
    }
    @Subscribe
    public void handlePirateDefeated(ShipAttackEvent event) {
        INavigableVessel vessel = event.getAttackedShip();
        INavigableVessel attackingShip = event.getAttackingShip();
        updateReputationDueToPirateDefeat(vessel, attackingShip);
    }
    @Subscribe
    public void handlePirateDefeated(ShipDefenseEvent event) {
        INavigableVessel playerVessel = event.getAttackedShip();
        INavigableVessel attackingShip = event.getAttackingShip();
        updateReputationDueToPirateDefeat(attackingShip, playerVessel);
    }

    private void updateReputationDueToPirateDefeat(INavigableVessel pirateVessel, INavigableVessel playerVessel) {
        if (pirateVessel.getOwner() instanceof ISeaPirate && playerVessel.getOwner() instanceof IPlayer) {
            if (!piratesState.getAllPirates().contains(pirateVessel.getOwner())) {
                IPlayer player = (IPlayer) playerVessel.getOwner();
                for (ICity city : map.getCities()) {
                    city.getReputation(player).update(15); // If the distruction was a Alderman task the increase is larger
                }
            }
        }
    }
}
