package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 18, 2016
 */
public enum EEventDecisionStrategyType implements IAIEventDecisionStrategyType {
    FLEET_SIZE(FleetBasedEventDecisionStrategy.class),
    CASH_AMOUNT(MoneyBasedEventDecisionStrategy.class),
    WARES_STORED(StorageBasedEventDecisionStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIEventDecisionStrategy> strategyClass;

    EEventDecisionStrategyType(Class<? extends IAIEventDecisionStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }
    public void setApplicationContext(org.springframework.context.ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }


    @Override
    public IAIEventDecisionStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
