package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategy;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * Default implementation of the weapon buy strategies.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 19, 2017
 */
public enum EWeaponBuyStrategyType implements IAIBuyWeaponStrategyType {
    FILL_HALF_SLOTS_WHEN_MANY_PIRATE_ATTACKS(BuyWeaponHighPirateActivityHalfSlotsFilledStrategy.class),
    FILL_HALF_SLOTS_WHEN_MANY_SUCCESSFUL_PIRATE_ATTACKS(BuyWeaponHighPirateSuccessHalfSlotsFilledStrategy.class),
    FILL_ALL_SLOTS_WHEN_MANY_SUCCESSFUL_PIRATE_ATTACKS(BuyWeaponHighPirateSuccessAllSlotsFilledStrategy.class);

    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIBuyWeaponStrategy> strategyClass;

    EWeaponBuyStrategyType(Class<? extends IAIBuyWeaponStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(org.springframework.context.ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIBuyWeaponStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
