package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * Event decision strategy based on the stored amount of required goofs.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 18, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class StorageBasedEventDecisionStrategy implements IAIEventDecisionStrategy {
    @MapType(key = IWare.class, value = Integer.class)
    private Map<IWare, Integer> minAmounts = new HashMap<>();

    public StorageBasedEventDecisionStrategy() {
        minAmounts.put(EWare.BEER, 20);
        minAmounts.put(EWare.WINE, 20);
        minAmounts.put(EWare.FISH, 2);
        minAmounts.put(EWare.MEAT, 2);
        minAmounts.put(EWare.GRAIN, 3);
        minAmounts.put(EWare.HONEY, 10);
    }

    @Override
    public boolean acceptMarriagBrokereOffer(IAIPlayer player) {
        return enoughStored(player, player.getHometown());
    }

    @Override
    public boolean acceptMarriageOffer(IAIPlayer player) {
        return enoughStored(player, player.getHometown());
    }

    @Override
    public boolean shouldOrderCelebration(IAIPlayer player, ICity city) {
        return enoughStored(player, city);
    }

    private boolean enoughStored(IPlayer player, ICity city) {
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent()) {
            for (IWare ware : minAmounts.keySet()) {
                ITradingOffice office = optOffice.get();
                AmountablePrice<IWare> stored = office.getWare(ware);
                if (stored.getAmount() < minAmounts.get(ware)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}
