package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Setter;

/**
 * Implements the trade step to by the some goods up to a maximum buy price. It also checks that
 * the ware is only loaded up to a certain maximum of the space on the ship.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckedBuyTradeStep extends BaseBuyTradeStep {

    @Setter
    private boolean executeNext = true;

    @Override
    public boolean execute() {
        IWare ware = getWare();
        INavigableVessel vessel = getVessel();
        IPlayer player = (IPlayer) vessel.getOwner();
        int size = vessel.getSize();
        int alreadyLoaded = vessel.getWare(ware).getAmount();
        int maxAmountBasedOnPercentage = (int) (size * ware.getAiMaxBuyPercentage()) - alreadyLoaded;
        int maxAbsoluteAmount = ware.getAiMaxBuyAbsolute() - alreadyLoaded;
        int affordableAmount = Math.min(maxAmountBasedOnPercentage, maxAbsoluteAmount);
        transferFromOfficeOrBuyFromCity(player, affordableAmount);
        return executeNext;

    }

    @Override
    public String toString() {
        return "CheckedBuyTradeStep{Buy "
                + getWare() + " for "
                + getVessel().getName() + " in "
                + getCity().getName() + " for a max price of"
                + getMaxBuyPrice() + "}";
    }

}
