package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * Implements the sell step for selling a single ware up to a minimum sell price and a maximum amount
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckedSellTradeStep implements ITradeStep {
    @Setter
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    private int maxAmount;
    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    @Setter
    private boolean executeNext = true;

    @Override
    public boolean execute() {
        int minSellPrice = vessel.getWare(ware).getAVGPrice();
        IAIPlayer player = (IAIPlayer) vessel.getOwner();
        tradeService.sellWareShipToCity(vessel, player, city, ware, maxAmount, Optional.of(minSellPrice));
        return executeNext;
    }
}
