package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static java.util.stream.Collectors.toList;

/**
 * Trade step for transferring all wares to the store if it can be stored and there is a store manager, to sell them.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 20, 2017
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class TransferToOfficeTradeStep implements ITradeStep {
    @Setter
    private ICity city;

    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    @Override
    public boolean execute() {
        IAIPlayer player = (IAIPlayer) vessel.getOwner();
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent()) {
            ITradingOffice office = optOffice.get();
            if (office.getSteward().isPresent()) {
                List<IWare> neededWares = tradeService.getBasicNeeds();
                List<IWare> transferableWares = vessel.getLoadedWares().stream()
                        .filter(ware -> neededWares.contains(ware))
                        .collect(toList());
                Map<IWare, Integer> map = new HashMap<>();
                for (IWare ware : transferableWares) {
                    int amount = vessel.getWare(ware).getAmount();
                    if (ware.isBarrelSizedWare()) {
                        amount *= 10;
                    }
                    int availableSpace = office.capacityProperty().get();
                    int movableAmount = Math.min(availableSpace, amount);
                    map.put(ware, movableAmount);
                }
                if (!map.isEmpty()) {
                    tradeService.transferFromVesselToStorage(vessel, player, city, map);
                }
            }
        }
        return true;
    }
}
