package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * Sea fight context for the blockade.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 26, 2016
 */
@ClassCategory({EClassCategory.MODEL, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
@EqualsAndHashCode
public class BlockadeSeafightContext  extends SeaFightContext {
    @Getter
    private final IBlockade blockade;
    @Getter
    @ListType(IShip.class)
    private List<IShip> capturedShips = new ArrayList<>();

    public BlockadeSeafightContext(IBlockade blockade) {
        super(ESeaFightType.BLOCKADE);
        this.blockade = blockade;
    }

    public void addCapturedShip(IShip ship) {
        capturedShips.add(ship);
    }
}
