package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Builder;
import lombok.Value;

/**
 * Entry to keep track of pirate activity.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
@Value
@Builder
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class PirateActivityEntry {
    private ISeaPirate pirate;
    private boolean fightWon;
    private int sukenShips;
    private int enteredShips;
    private int lootedShips;

}
