/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.ClockTickPostDayChange;
import ch.sahits.game.event.data.IClockTick;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.PeriodicalTimeMonthEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeYearEndUpdate;
import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.openpatrician.clientserverinterface.event.IEventPropagator;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.service.Timer;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import javafx.application.Platform;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ClockTickTimer
extends Timer {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private Date clock;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private IEventPropagator messagePropagator;
    private boolean dayChanged = false;
    private static Object lock = new Object();

    public ClockTickTimer(long interval, long duration) {
        super(interval, duration);
    }

    @PostConstruct
    private void register() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    protected void onTick() {
        this.tick();
        this.timerEventBus.post((Object)new IClockTick(){});
    }

    protected void onFinish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Object object = lock;
        synchronized (object) {
            ClockTickDayChange event;
            int dayBefore = this.clock.getCurrentDate().getDayOfMonth();
            this.clock.updateTime(this.clock.getCurrentDate().plusMinutes(this.clock.getTickUpdate()));
            if (dayBefore != this.clock.getCurrentDate().getDayOfMonth()) {
                LocalDateTime last;
                Platform.runLater(() -> this.clock.dayDateBinding().invalidate());
                event = new ClockTickDayChange();
                this.timerEventBus.post((Object)event);
                this.dayChanged = true;
                this.logger.info("Day change");
                DayOfWeek dayOfWeek = this.clock.getCurrentDate().getDayOfWeek();
                if (dayOfWeek == DayOfWeek.SUNDAY) {
                    this.timerEventBus.post((Object)new PeriodicalTimeWeekEndUpdate());
                }
                int monthOfYear = this.clock.getCurrentDate().getMonthValue();
                int dayOfMonth = this.clock.getCurrentDate().getDayOfMonth();
                if (monthOfYear == 12 && dayOfMonth == 31) {
                    this.timerEventBus.post((Object)new PeriodicalTimeYearEndUpdate());
                }
                if (dayOfMonth == (last = this.clock.getCurrentDate().with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
                    PeriodicalTimeMonthEndUpdate event1 = new PeriodicalTimeMonthEndUpdate();
                    this.timerEventBus.post((Object)event1);
                }
            }
            if (this.dayChanged) {
                this.dayChanged = false;
                event = new ClockTickPostDayChange();
                this.timerEventBus.post((Object)event);
            }
        }
        this.timerEventBus.post((Object)new ClockTick());
    }

    @Subscribe
    public void handlePause(PauseGame event) {
        this.pause();
    }

    @Subscribe
    public void handleResume(ResumeGame event) {
        this.resume();
    }
}

