/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.engine.event.EventEngineState;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageOfferDeclinedTimedTask
extends TimedTask {
    public static final int OFFER_VALID_DURATION = 75;
    @Autowired
    private Date date;
    @Autowired
    private EventEngineState eventState;
    private IPlayer player;

    public MarriageOfferDeclinedTimedTask(IPlayer player) {
        this.player = player;
    }

    @PostConstruct
    private void init() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(75L));
    }

    public void run() {
        this.eventState.resetMarriedState(this.player);
    }
}

