/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PostStateDialogToHumanPlayerTask
extends TimedTask {
    private final IDialogState state;
    private final IPlayer player;
    private final String messageKey;
    private final Object[] messageParams;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public PostStateDialogToHumanPlayerTask(LocalDateTime executionTime, IDialogState state, IPlayer player, String messageKey, Object[] messageParams) {
        this.setExecutionTime(executionTime);
        this.state = state;
        this.player = player;
        this.messageKey = messageKey;
        this.messageParams = messageParams;
    }

    public void run() {
        if (this.player instanceof IHumanPlayer) {
            DisplayStateMessage message = new DisplayStateMessage(this.messageKey, this.state, this.messageParams);
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)message));
        }
    }
}

