/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ChurchUpgradeTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.EChurchExtension;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.collection.CityChurchRegistry;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ChurchEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private CityChurchRegistry churchMap;
    @Autowired
    private ModelStateAccessor churchProvider;
    @Autowired
    private ServerSideTaskFactory taskFactory;

    @PostConstruct
    private void init() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekEndUpdate event) {
        for (ICity iCity : this.churchMap.keySet()) {
            IChurch church = this.churchProvider.getChurch(iCity);
            if (!church.getExtensionLevel().getNextExtensionLevel().isPresent()) continue;
            EChurchExtension next = (EChurchExtension)church.getExtensionLevel().getNextExtensionLevel().get();
            int collectedDonationsForExtension = church.getCollectedDonationsForExtension();
            if (collectedDonationsForExtension < next.getRequiredCash()) continue;
            int delay = this.rnd.nextInt(30);
            LocalDateTime executionTime = this.date.getCurrentDate().plusDays(delay);
            ChurchUpgradeTimedTask task = this.taskFactory.getChurchUpgradeTask(church, executionTime);
            this.timedTaskListener.add((TimedTask)task);
        }
    }

    public void establishChurch(ICity city) {
        IChurch church = this.stateFactory.createChurch();
        this.churchMap.put((Object)city, (Object)church);
    }
}

