/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.engine.EngineFactory;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallBuildingTask;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityWallMaterialBuyingTask
extends TimedTask {
    private final ICityHall cityHall;
    @Autowired
    @XStreamOmitField
    private EngineFactory engineFactory;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    @Autowired
    private Date date;

    public CityWallMaterialBuyingTask(ICityHall cityHall, LocalDateTime electionTime) {
        this.cityHall = cityHall;
        this.setExecutionTime(electionTime);
    }

    public void run() {
        ICity city = this.cityHall.getCity();
        CityWall cityWall = city.getCityState().getCityWall();
        if (cityWall.getUsedBricks() == cityWall.getBoughtBricks()) {
            int amountRequired = Math.min(10, cityWall.getRequiredBricks() - cityWall.getBoughtBricks());
            int availableAmountCity = city.getWare((IWare)EWare.BRICK).getAmount();
            int avgPrice = this.computablePrice.buyPrice((ITradable)EWare.BRICK, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountRequired));
            if (avgPrice < 90) {
                int bought = city.move((IWare)EWare.BRICK, -amountRequired, this.cityHall.getMayor());
                cityWall.setBoughtBricks(cityWall.getBoughtBricks() - bought);
                avgPrice = this.computablePrice.buyPrice((ITradable)EWare.BRICK, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(-bought));
                ((Treasury)this.cityHall.getTreasury()).subtractBuildingCosts(avgPrice * bought);
                LocalDateTime buildDate = this.date.getCurrentDate().plusDays(5L);
                CityWallBuildingTask task = this.engineFactory.getCityWallBuildingTask(cityWall, buildDate);
                this.timedTaskListener.add((TimedTask)task);
            }
        }
    }
}

