/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.AIPlayerEngine;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AITradeChecker {
    @Autowired
    private TravellingVessels vessels;
    @Autowired
    private IMap map;
    @Autowired
    private AIPlayerEngine playerEngine;
    @Autowired
    private ShipService shipService;

    public boolean isEngagedInTrading(INavigableVessel vessel) {
        if (this.vessels.isTravelling(vessel)) {
            return true;
        }
        for (ICity city : this.map.getCities()) {
            IShipyard shipyard = city.getCityState().getShipyardState();
            List repairlist = shipyard.getShipRepairList();
            for (IShipDueDate dueDate : repairlist) {
                if (!dueDate.getShip().equals(vessel)) continue;
                return true;
            }
        }
        if (vessel.getNumberOfSailors() < this.shipService.getMinNumberOfSailors(vessel)) {
            return true;
        }
        return this.playerEngine.executeCurrentTrade(vessel);
    }

    public boolean shouldBeTrading(INavigableVessel vessel) {
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        ITradeMissionData missionData = player.getTradeMission(vessel);
        return missionData == null || !(missionData instanceof ISpecialMission);
    }
}

