/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseHireCaptainStrategy
implements IAICaptainHireStrategy {
    @Autowired
    protected CaptainsState captainsState;
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    @Autowired
    private AsyncEventBus clientServerEventBus;

    public Optional<ICaptain> getCaptain(ICity city) {
        Optional optCaptain = this.captainsState.getCaptain(city);
        return optCaptain;
    }

    public void hire(IAIPlayer player, IShip vessel, ICaptain captain, ICity city) {
        vessel.setCaptain(captain);
        this.captainsState.hireCaptain(captain, city);
        this.clientServerEventBus.post((Object)new PersonLeavesTavernEvent(city, (IPerson)captain));
    }
}

