/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.MapProxy;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesCheckedSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AmountBasedAggregatedDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyWeaponTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckedTransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireDismissTradeManagerTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToShipTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.UpgradeShipTradeStep;
import ch.sahits.game.openpatrician.event.data.RefitFinishedEvent;
import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.event.data.ai.HireSailorEvent;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public abstract class BasePlayerTradeStrategy
implements IAITradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @XStreamOmitField
    private MapProxy mapProxy;
    @Autowired
    private ApplicationContext context;
    @Autowired
    @XStreamOmitField
    private MapService mapService;
    @Autowired
    private IMap map;
    protected IAITradeStrategyType tradeStrategyType;

    protected boolean isMatchingTradeStrategy(INavigableVessel vessel) {
        if (vessel.getOwner() instanceof IAIPlayer) {
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            IAITradeStrategyType tradeStrategyType = player.getTradeStrategyType(vessel);
            return tradeStrategyType.equals(this.tradeStrategyType);
        }
        return false;
    }

    public ICity getCityToRestartTradeCycle(INavigableVessel vessel) {
        return this.mapService.findNearestCity(vessel.getLocation());
    }

    public ITradeStep getNextStep(IAIPlayer player, INavigableVessel vessel) {
        return player.getNextTradeStep(vessel);
    }

    public boolean hasMoreTradeSteps(IAIPlayer player, INavigableVessel vessel) {
        return player.hasMoreTradeSteps(vessel);
    }

    public void append(IAIPlayer player, INavigableVessel vessel, ITradeStep step) {
        player.addTradeStep(step, vessel);
    }

    public void inject(IAIPlayer player, INavigableVessel vessel, ITradeStep step) {
        player.injectTradeStep(step, vessel);
    }

    public List<Pair<IWare, Number>> getMostNeededWares(ICityProductionConsumptionKnowledge knowledge) {
        Preconditions.checkNotNull((Object)knowledge, (Object)"The city production knowledge may not be null");
        ArrayList<Pair> need = new ArrayList<Pair>();
        for (EWare ware : EWare.values()) {
            int stored = knowledge.getStoredAmount((IWare)ware);
            int produced = knowledge.getProductionAmount((IWare)ware);
            int consumed = knowledge.getConsumptionAmount((IWare)ware);
            int value = consumed == 0 ? Integer.MAX_VALUE : stored + produced - consumed;
            need.add(new Pair((Object)ware, (Object)value));
        }
        return need.stream().sorted(new WareNeedComparator()).collect(Collectors.toList());
    }

    public boolean isNeeded(ICityProductionConsumptionKnowledge knowledge, IWare ware) {
        List<Pair<IWare, Number>> needs = this.getMostNeededWares(knowledge);
        for (Pair<IWare, Number> need : needs) {
            if (((IWare)need.getKey()).equals(ware) && ((Number)need.getValue()).intValue() < 10) {
                return true;
            }
            if (!((IWare)need.getKey()).equals(ware) && ((Number)need.getValue()).intValue() <= 10) continue;
            return false;
        }
        return false;
    }

    public List<Pair<IWare, Number>> getMostNeededWares(ICityProductionConsumptionKnowledge knowledge, INavigableVessel vessel) {
        List<Pair<IWare, Number>> sortedNeeds = this.getMostNeededWares(knowledge);
        ListIterator<Pair<IWare, Number>> iterator = sortedNeeds.listIterator();
        while (iterator.hasNext()) {
            Pair<IWare, Number> need = iterator.next();
            if (vessel.getWare((IWare)need.getKey()).getAmount() <= 0) continue;
            int value = ((Number)need.getValue()).intValue() + vessel.getWare((IWare)need.getKey()).getAmount();
            iterator.remove();
            iterator.add((Pair<IWare, Number>)new Pair(need.getKey(), (Object)value));
        }
        return sortedNeeds.stream().sorted(new WareNeedComparator()).collect(Collectors.toList());
    }

    protected List<IWare> getWaresNeedIn(IProductionConsumptionKnowledge knowledge, ICityProductionConsumptionKnowledge knowledgeCurrentTown, ICity nextStop) {
        ICityProductionConsumptionKnowledge knowledgeFirstTown = knowledge.getKnowlege(nextStop);
        List<Pair<IWare, Number>> sortedNeeds = this.getMostNeededWares(knowledgeFirstTown);
        ArrayList<IWare> deliverWare = new ArrayList<IWare>();
        for (Pair<IWare, Number> need : sortedNeeds) {
            if (knowledgeCurrentTown.getProductionAmount((IWare)need.getKey()) <= 0) continue;
            deliverWare.add((IWare)need.getKey());
        }
        return deliverWare;
    }

    protected ICity findNextStopForBuying(ICity baseTown, IProductionConsumptionKnowledge knowledge, List<IWare> waresOfInterest, INavigableVessel vessel, ICity exclude) {
        List cities = knowledge.findListWithProductionsMinimalDistance(baseTown, waresOfInterest.get(0), vessel);
        if (((ICity)cities.get(0)).equals(exclude) && cities.size() > 1) {
            return (ICity)cities.get(1);
        }
        return (ICity)cities.get(0);
    }

    protected ICity findNextStopForSelling(ICity baseTown, IProductionConsumptionKnowledge knowledge, List<IWare> waresOfInterest, INavigableVessel vessel, ICity exclude) {
        List cities = knowledge.findListWithConsumptionMinimalDistance(baseTown, waresOfInterest.get(0), vessel);
        if (((ICity)cities.get(0)).equals(exclude) && cities.size() > 1) {
            return (ICity)cities.get(1);
        }
        return (ICity)cities.get(0);
    }

    protected TravelToTradeStep createTravelToStep(INavigableVessel vessel, ICity travelToCity) {
        TravelToTradeStep travelTo = (TravelToTradeStep)this.context.getBean(TravelToTradeStep.class);
        travelTo.setDestinationCity(travelToCity);
        travelTo.setVessel(vessel);
        return travelTo;
    }

    protected CheckForRepairTradeStep createCheckRepairStep(INavigableVessel vessel, ICity city) {
        CheckForRepairTradeStep repairStep = (CheckForRepairTradeStep)this.context.getBean(CheckForRepairTradeStep.class);
        repairStep.setCity(city);
        repairStep.setVessel(vessel);
        return repairStep;
    }

    protected HireSailorsStep createHireSailorStep(INavigableVessel vessel, ICity city) {
        HireSailorsStep hireSailors = (HireSailorsStep)this.context.getBean(HireSailorsStep.class);
        hireSailors.setShip(vessel);
        hireSailors.setCity(city);
        return hireSailors;
    }

    protected TakeLoanTradeStep createCheckAndTakeLoanStep(IAIPlayer player, ICity city) {
        TakeLoanTradeStep takeLoan = (TakeLoanTradeStep)this.context.getBean(TakeLoanTradeStep.class);
        takeLoan.setCity(city);
        takeLoan.setPlayer(player);
        return takeLoan;
    }

    protected PayBackLoanTradeStep createPaybackLoanStep(IAIPlayer player, ICity city) {
        PayBackLoanTradeStep takeLoan = (PayBackLoanTradeStep)this.context.getBean(PayBackLoanTradeStep.class);
        takeLoan.setCity(city);
        takeLoan.setPlayer(player);
        return takeLoan;
    }

    protected AggregatedBuyTradeStep createAggregatedBuyTradeStep(INavigableVessel vessel, ICity city, List<IWare> waresToBuy) {
        AggregatedBuyTradeStep buyStepHometown = (AggregatedBuyTradeStep)this.context.getBean(AggregatedBuyTradeStep.class);
        buyStepHometown.setCity(city);
        buyStepHometown.setVessel(vessel);
        buyStepHometown.setExecuteNext(true);
        for (IWare ware : waresToBuy) {
            int maxPrice = ware.getMaxBuyPriceOffensive();
            buyStepHometown.addBuyStep(ware, maxPrice);
        }
        return buyStepHometown;
    }

    protected AggregatedCheckedBuyTradeStep createAggregatedCheckedBuyTradeStep(INavigableVessel vessel, ICity city, List<IWare> waresToBuy) {
        AggregatedCheckedBuyTradeStep buyStepHometown = (AggregatedCheckedBuyTradeStep)this.context.getBean(AggregatedCheckedBuyTradeStep.class);
        buyStepHometown.setCity(city);
        buyStepHometown.setVessel(vessel);
        buyStepHometown.setExecuteNext(true);
        for (IWare ware : waresToBuy) {
            int maxPrice = ware.getMaxBuyPriceOffensive();
            buyStepHometown.addBuyStep(ware, maxPrice);
        }
        return buyStepHometown;
    }

    protected AggregatesSellTradeStep createAggregatedSellStep(INavigableVessel vessel, ICity city, List<IWare> waresToSell) {
        AggregatesSellTradeStep sellStep = (AggregatesSellTradeStep)this.context.getBean(AggregatesSellTradeStep.class);
        sellStep.setVessel(vessel);
        sellStep.setCity(city);
        sellStep.setExecuteNext(true);
        for (IWare ware : waresToSell) {
            sellStep.addSellStep(ware);
        }
        return sellStep;
    }

    protected AggregatesCheckedSellTradeStep createAggregatedCheckedSellStep(INavigableVessel vessel, ICity city, Map<IWare, Integer> waresToSell) {
        AggregatesCheckedSellTradeStep sellStep = (AggregatesCheckedSellTradeStep)this.context.getBean(AggregatesCheckedSellTradeStep.class);
        sellStep.setVessel(vessel);
        sellStep.setCity(city);
        sellStep.setExecuteNext(true);
        waresToSell.entrySet().stream().forEach(entry -> sellStep.addSellStep((IWare)entry.getKey(), (Integer)entry.getValue()));
        return sellStep;
    }

    protected AggregatesDumpTradeStep createAggregatedDumpStep(INavigableVessel vessel, ICity city, List<IWare> waresToSell) {
        AggregatesDumpTradeStep sellStep = (AggregatesDumpTradeStep)this.context.getBean(AggregatesDumpTradeStep.class);
        sellStep.setVessel(vessel);
        sellStep.setCity(city);
        sellStep.setExecuteNext(true);
        for (IWare ware : waresToSell) {
            sellStep.addSellStep(ware);
        }
        return sellStep;
    }

    protected AmountBasedAggregatedDumpTradeStep createConditionalAggregatedDumpStep(INavigableVessel vessel, ICity city, List<IWare> waresToSell, int maxAmount) {
        AmountBasedAggregatedDumpTradeStep sellStep = (AmountBasedAggregatedDumpTradeStep)this.context.getBean(AmountBasedAggregatedDumpTradeStep.class);
        sellStep.setVessel(vessel);
        sellStep.setCity(city);
        sellStep.setExecuteNext(true);
        sellStep.setMaxAmount(maxAmount);
        for (IWare ware : waresToSell) {
            sellStep.addSellStep(ware);
        }
        return sellStep;
    }

    protected CheckHireCaptainTradeStep createHireCaptain(INavigableVessel vessel, ICity city, IAIPlayer player) {
        CheckHireCaptainTradeStep hireCaptain = (CheckHireCaptainTradeStep)this.context.getBean(CheckHireCaptainTradeStep.class);
        hireCaptain.setVessel(vessel);
        hireCaptain.setCity(city);
        hireCaptain.setPlayer(player);
        return hireCaptain;
    }

    protected GuildJoinTradeStep createJoinGuildTradeStep(INavigableVessel vessel, ICity city, IAIPlayer player) {
        GuildJoinTradeStep tradeStep = (GuildJoinTradeStep)this.context.getBean(GuildJoinTradeStep.class);
        tradeStep.setVessel(vessel);
        tradeStep.setCity(city);
        tradeStep.setPlayer(player);
        return tradeStep;
    }

    protected HireDismissTradeManagerTradeStep createHireDismissTradeManagerTradeStep(ICity city, IAIPlayer player) {
        HireDismissTradeManagerTradeStep tradeStep = (HireDismissTradeManagerTradeStep)this.context.getBean(HireDismissTradeManagerTradeStep.class);
        tradeStep.setCity(city);
        tradeStep.setPlayer(player);
        return tradeStep;
    }

    protected BuyWeaponTradeStep createWeaponBuyTradeStep(INavigableVessel vessel, IAIPlayer player, ICity city) {
        BuyWeaponTradeStep tradeStep = (BuyWeaponTradeStep)this.context.getBean(BuyWeaponTradeStep.class);
        tradeStep.setVessel(vessel);
        tradeStep.setPlayer(player);
        tradeStep.setCity(city);
        return tradeStep;
    }

    protected TransferToOfficeTradeStep createTransferToOfficeTradeStep(INavigableVessel vessel, ICity city) {
        TransferToOfficeTradeStep tradeStep = (TransferToOfficeTradeStep)this.context.getBean(TransferToOfficeTradeStep.class);
        tradeStep.setCity(city);
        tradeStep.setVessel(vessel);
        return tradeStep;
    }

    protected CheckedTransferToOfficeTradeStep createCheckedTransferToOfficeTradeStep(INavigableVessel vessel, ICity city, Map<IWare, Integer> transferAmounts) {
        CheckedTransferToOfficeTradeStep tradeStep = (CheckedTransferToOfficeTradeStep)this.context.getBean(CheckedTransferToOfficeTradeStep.class);
        tradeStep.setCity(city);
        tradeStep.setVessel(vessel);
        tradeStep.setTransferAmounts(transferAmounts);
        return tradeStep;
    }

    protected TransferToShipTradeStep createTransferToShipTradeStep(INavigableVessel vessel, ICity city, Map<IWare, Integer> transfereableAmounts) {
        TransferToShipTradeStep tradeStep = (TransferToShipTradeStep)this.context.getBean(TransferToShipTradeStep.class);
        tradeStep.setCity(city);
        tradeStep.setVessel(vessel);
        tradeStep.setTransferableWares(transfereableAmounts);
        return tradeStep;
    }

    protected UpgradeShipTradeStep createUpgradeShipTradeStep(INavigableVessel vessel, IAIPlayer player) {
        UpgradeShipTradeStep tradeStep = (UpgradeShipTradeStep)this.context.getBean(UpgradeShipTradeStep.class);
        tradeStep.setVessel(vessel);
        tradeStep.setPlayer(player);
        return tradeStep;
    }

    public boolean executeTradeSteps(IAIPlayer player, INavigableVessel vessel) {
        boolean proceedWithExecutionOfNextStep = true;
        if (this.hasMoreTradeSteps(player, vessel)) {
            try {
                this.logger.debug("Executed more steps for {} of {} {}", (Object)vessel.getName(), (Object)player.getName(), (Object)player.getLastName());
                ITradeStep nextStep = this.getNextStep(player, vessel);
                this.logger.debug("Next step for {} of {} {}: {}", (Object)vessel.getName(), (Object)player.getName(), (Object)player.getLastName(), (Object)nextStep);
                if (nextStep.execute()) {
                    this.logger.debug("Execute recursive after {} for {}", (Object)nextStep, (Object)vessel.getName());
                    proceedWithExecutionOfNextStep = this.executeTradeSteps(player, vessel);
                }
                proceedWithExecutionOfNextStep = false;
                this.logger.debug("Do not execute any further steps after: {} for {}", (Object)nextStep, (Object)vessel.getName());
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (RuntimeException e) {
                this.logger.error("Failed in execution of trade step for strategy: " + player.getTradeStrategyType(vessel) + " player " + player.getName() + " " + player.getLastName() + ", vessel: " + vessel.getName(), (Throwable)e);
            }
        } else {
            throw new IllegalStateException(String.format("There are no further steps defined for %s of %s %s for strategy %s", vessel.getName(), player.getName(), player.getLastName(), this.getClass().getName()));
        }
        player.updateTradeWaitingStatus(vessel, !proceedWithExecutionOfNextStep);
        return proceedWithExecutionOfNextStep;
    }

    @Subscribe
    public void handleRepairFinished(RepairFinishedEvent event) {
        INavigableVessel vessel = event.getShip();
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        if (this.isMatchingTradeStrategy(vessel)) {
            Preconditions.checkArgument((boolean)this.hasMoreTradeSteps(player, vessel), (Object)("There most be steps defined after repair for " + vessel.getName() + " of " + player.getName() + " " + player.getLastName()));
            player.updateTradeWaitingStatus(vessel, false);
            this.executeTradeSteps(player, vessel);
        }
    }

    @Subscribe
    public void handleRefitFinished(RefitFinishedEvent event) {
        IShip vessel = event.getShip();
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        if (this.isMatchingTradeStrategy((INavigableVessel)vessel)) {
            Preconditions.checkArgument((boolean)this.hasMoreTradeSteps(player, (INavigableVessel)vessel), (Object)("There most be steps defined after repair for " + vessel.getName() + " of " + player.getName() + " " + player.getLastName()));
            player.updateTradeWaitingStatus((INavigableVessel)vessel, false);
            this.executeTradeSteps(player, (INavigableVessel)vessel);
        }
    }

    @Subscribe
    public void handleHireSailors(HireSailorEvent event) {
        INavigableVessel ship = event.getShip();
        ICity city = event.getCity();
        IAIPlayer player = (IAIPlayer)ship.getOwner();
        if (this.isMatchingTradeStrategy(ship)) {
            HireSailorsStep hireSailor = this.createHireSailorStep(ship, city);
            this.inject(player, ship, hireSailor);
            this.executeTradeSteps(player, ship);
        }
    }

    protected List<IWare> getLoadedWares(INavigableVessel vessel) {
        return vessel.getLoadedWares().stream().filter(ware -> vessel.getWare(ware).getAmount() > 0).collect(Collectors.toList());
    }

    protected ArrayList<IWare> findWaresOfInterest(List<Pair<IWare, Number>> sortedNeeds) {
        ArrayList<IWare> waresOfInterest = new ArrayList<IWare>();
        for (Pair<IWare, Number> need : sortedNeeds) {
            if (((Number)need.getValue()).doubleValue() < 0.0 || waresOfInterest.isEmpty()) {
                waresOfInterest.add((IWare)need.getKey());
                continue;
            }
            if (waresOfInterest.size() >= 2) break;
            waresOfInterest.add((IWare)need.getKey());
        }
        return waresOfInterest;
    }

    protected ICity findDestinationToBuyRequiredProductionWares(IAIPlayer player, List<IWare> requiredWares, INavigableVessel vessel, Set<ICity> excludeCity) {
        Optional<ICity> optDest = this.findCityWithAllRequiredWares(requiredWares, player, vessel, excludeCity);
        ICity destination = optDest.isPresent() ? optDest.get() : this.findCitySupplyingWare(player, requiredWares.get(0), vessel, excludeCity);
        return destination;
    }

    @VisibleForTesting
    Optional<ICity> findCityWithAllRequiredWares(List<IWare> requiredWares, IAIPlayer player, INavigableVessel vessel, Set<ICity> excludeCity) {
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        ArrayList<ICity> cities = new ArrayList<ICity>();
        ArrayList mapCities = new ArrayList(this.mapProxy.getAllReachableNonBlockadedCities(vessel));
        excludeCity.stream().forEach(city -> mapCities.remove(city));
        for (ICity city2 : mapCities) {
            ICityProductionConsumptionKnowledge cityKnowledge = knowledge.getKnowlege(city2);
            boolean producesAll = true;
            for (IWare ware : requiredWares) {
                int productionAmount = cityKnowledge.getProductionAmount(ware);
                if (productionAmount >= 1) continue;
                producesAll = false;
                break;
            }
            if (!producesAll) continue;
            cities.add(city2);
        }
        if (cities.isEmpty()) {
            return Optional.empty();
        }
        Collections.shuffle(cities);
        return Optional.of(cities.get(0));
    }

    @VisibleForTesting
    ICity findCitySupplyingWare(IAIPlayer player, IWare ware, INavigableVessel vessel, Set<ICity> excludeCity) {
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        ArrayList mapCities = new ArrayList(this.mapProxy.getAllReachableNonBlockadedCities(vessel));
        excludeCity.stream().forEach(city -> mapCities.remove(city));
        for (ICity city2 : mapCities) {
            ICityProductionConsumptionKnowledge cityKnowledge = knowledge.getKnowlege(city2);
            if (cityKnowledge.getProductionAmount(ware) <= 0) continue;
            return city2;
        }
        this.logger.warn("Did not find city supplying ware: {}, excluding {}. Try finding city that should produce it", (Object)ware, (Object)excludeCity.iterator().next().getName());
        for (ICity city2 : mapCities) {
            for (IWare produced : city2.getEffectiveProduction()) {
                if (!produced.equals(ware)) continue;
                return city2;
            }
        }
        for (ICity city2 : mapCities) {
            for (IWare produced : city2.getIneffectiveProduction()) {
                if (!produced.equals(ware)) continue;
                return city2;
            }
        }
        return null;
    }

    protected ICity findProvidingWares(ICity source, Collection<IWare> wares, Collection<ICity> excluded, IAIPlayer player, INavigableVessel vessel) {
        double width = this.map.getDimension().getWidth();
        int nbRequiredWares = wares.size();
        double distanceOnePenaltyPoint = width / (double)(nbRequiredWares * 4);
        Optional<ICity> optCity = this.findCityWithAllRequiredWares(new ArrayList<IWare>(wares), player, vessel, new HashSet<ICity>(excluded));
        if (optCity.isPresent() && optCity.get().getCoordinates().distance(source.getCoordinates()) < distanceOnePenaltyPoint * (double)nbRequiredWares) {
            return optCity.get();
        }
        TreeMap<Double, ICity> prioCityMap = new TreeMap<Double, ICity>();
        ArrayList cities = new ArrayList(this.mapProxy.getAllReachableNonBlockadedCities(vessel));
        cities.removeAll(excluded);
        for (ICity city : cities) {
            double penality = 0.0;
            double distance = city.getCoordinates().distance(source.getCoordinates());
            penality = distance / distanceOnePenaltyPoint;
            for (IWare ware : wares) {
                if (this.mapService.produces(city, ware)) continue;
                penality += 1.0;
            }
            prioCityMap.put(penality, city);
        }
        return (ICity)prioCityMap.pollFirstEntry().getValue();
    }

    protected void addDefaultTradeSteps(INavigableVessel vessel, IAIPlayer player, ICity city, ICity nextStop, Set<IWare> nonSellableWares, Set<IWare> buyWares, boolean skipRepair) {
        LinkedList<IWare> sellWares = new LinkedList<IWare>();
        sellWares.addAll(this.getLoadedWares(vessel));
        sellWares.removeAll(nonSellableWares);
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        buyWares.addAll(this.getWaresNeedIn(knowledge, knowledge.getKnowlege(nextStop), nextStop));
        AggregatesSellTradeStep sellStep = this.createAggregatedSellStep(vessel, city, sellWares);
        this.append(player, vessel, sellStep);
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, city);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, city, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, city, player);
        this.append(player, vessel, joinTradeStep);
        HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(city, player);
        this.append(player, vessel, hireTradeManager);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, city);
        this.append(player, vessel, takeLoanStep);
        BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, city);
        this.append(player, vessel, buyWeaponsStep);
        AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, city, new ArrayList<IWare>(buyWares));
        this.append(player, vessel, buyStepHometown);
        UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
        this.append(player, vessel, upgradeShipStep);
        if (!skipRepair) {
            CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, city);
            this.append(player, vessel, repairStep);
        }
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
        this.append(player, vessel, travelTo);
    }

    private static class WareNeedComparator
    implements Comparator<Pair<IWare, Number>> {
        private WareNeedComparator() {
        }

        @Override
        public int compare(Pair<IWare, Number> firstPair, Pair<IWare, Number> secondPair) {
            return (int)Math.rint(((Number)firstPair.getValue()).doubleValue() - ((Number)secondPair.getValue()).doubleValue());
        }
    }
}

