/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategy;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public abstract class BaseRepairStrategy
implements IAIShipRepairStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ShipyardEngine shipyardEngine;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public void repair(INavigableVessel vessel, ICity city) {
        Preconditions.checkState((boolean)vessel.getLocation().equals((Object)city.getCoordinates()), (Object)("The vessel " + vessel.getName() + " is not in the city " + city.getCoordinates() + " but at " + vessel.getLocation()));
        IShipyard shipyard = city.getCityState().getShipyardState();
        if (vessel instanceof IConvoy) {
            List<IShip> ships = this.dissolveConvoy((IConvoy)vessel, city);
            for (IShip ship : ships) {
                this.shipyardEngine.repairAIShip(shipyard, ship);
            }
        } else {
            this.shipyardEngine.repairAIShip(shipyard, (IShip)vessel);
        }
        this.logger.debug("Repair vessel {} in {}", (Object)vessel.getName(), (Object)city.getName());
    }

    List<IShip> dissolveConvoy(IConvoy convoy, ICity city) {
        ArrayList<IShip> shipList = new ArrayList<IShip>();
        for (IShip ship : convoy.getShips()) {
            ship.setAvailable(true);
            IShipOwner owner = ship.getOwner();
            convoy.removeShip(ship);
            ship.parentShipProperty().setValue(null);
            if (owner instanceof IHumanPlayer) {
                DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.convoyDissolveNotification", new Object[]{convoy.getName(), ship.getName(), city.getName()});
                TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)owner, (Object)msg);
                this.clientServerEventBus.post((Object)targetMsg);
            }
            if (owner instanceof IPlayer) {
                IPlayer player = (IPlayer)owner;
                player.addSelectableVessel((INavigableVessel)ship);
            }
            if (owner.equals(convoy.getOwner())) {
                shipList.add(ship);
            }
            this.clientServerEventBus.post((Object)new ShipEntersPortEvent((INavigableVessel)ship, city));
        }
        return shipList;
    }
}

