/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.MapProxy;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.CentralStorageDeliverMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageHintContext;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageStrategyHint;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesCheckedSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyWeaponTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckedTransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireDismissTradeManagerTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToShipTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.UpgradeShipTradeStep;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.ITradeStategyHint;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CentralStorageDeliveryTradeStrategy
extends BasePlayerTradeStrategy {
    @Autowired
    private MapProxy map;
    @Autowired
    private ShipService shipService;
    @Autowired
    private Date date;

    public CentralStorageDeliveryTradeStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.DELIVER_WARES_FROM_CENTRAL_STORAGE;
    }

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        CentralStorageStrategyHint hint = null;
        Object centralStorage = null;
        for (ICity city : this.map.getAllReachableNonBlockadedCities(vessel)) {
            for (ITradeStategyHint h : player.getPlayerContext().getHints(city)) {
                CentralStorageStrategyHint hint1;
                CentralStorageHintContext context;
                if (!(h instanceof CentralStorageStrategyHint) || !(context = (CentralStorageHintContext)(hint1 = (CentralStorageStrategyHint)h).getContext()).getDistributingVessels().isEmpty()) continue;
                hint = hint1;
                centralStorage = city;
                break;
            }
            if (hint == null) continue;
            break;
        }
        Preconditions.checkNotNull(hint, (Object)"The CentralStorageStrategyHint could not be found");
        CentralStorageHintContext context = (CentralStorageHintContext)hint.getContext();
        Optional optCity = this.shipService.findCity(vessel);
        CentralStorageDeliverMissionData missionData = new CentralStorageDeliverMissionData();
        if (optCity.isPresent()) {
            ICity city = (ICity)optCity.get();
            if (centralStorage.equals(city)) {
                this.handleTradeInCentralStorage(player, vessel, city, context);
                missionData.setLastVisit(this.date.getCurrentDate());
            } else {
                this.addDefaultTradeSteps(vessel, player, city, (ICity)centralStorage, new HashSet<IWare>(), new HashSet<IWare>(context.getWares()), false);
            }
        } else {
            TravelToTradeStep travelTo = this.createTravelToStep(vessel, (ICity)centralStorage);
            this.append(player, vessel, travelTo);
        }
        missionData.setContext(context);
        missionData.setSourceCity((ICity)centralStorage);
        player.setTradeMission(vessel, (ITradeMissionData)missionData);
    }

    @VisibleForTesting
    void handleTradeInCentralStorage(IAIPlayer player, INavigableVessel vessel, ICity centralStorageCity, CentralStorageHintContext context) {
        CentralStorageDeliverMissionData missionData = (CentralStorageDeliverMissionData)player.getTradeMission(vessel);
        TransferToOfficeTradeStep trasferToOfficeStep = this.createTransferToOfficeTradeStep(vessel, centralStorageCity);
        this.append(player, vessel, trasferToOfficeStep);
        HashMap<IWare, Integer> requiredWares = new HashMap<IWare, Integer>();
        ITradingOffice office = (ITradingOffice)player.findTradingOffice(centralStorageCity).get();
        IProductionConsumptionKnowledge globalKnowledge = player.getProductionAndConsumptionKnowledge();
        if (missionData.getLastVisit() == null) {
            this.fillRequiredWaresAvailableBased(requiredWares, context, office);
        } else {
            this.fillRequiredWaresConsumptionBased(requiredWares, context, missionData, globalKnowledge);
        }
        ICity nextStop = this.getNextStop(centralStorageCity, missionData);
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, centralStorageCity);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, centralStorageCity, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, centralStorageCity, player);
        this.append(player, vessel, joinTradeStep);
        HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(centralStorageCity, player);
        this.append(player, vessel, hireTradeManager);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, centralStorageCity);
        this.append(player, vessel, takeLoanStep);
        BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, centralStorageCity);
        this.append(player, vessel, buyWeaponsStep);
        TransferToShipTradeStep transferToShipStep = this.createTransferToShipTradeStep(vessel, centralStorageCity, requiredWares);
        this.append(player, vessel, transferToShipStep);
        UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
        this.append(player, vessel, upgradeShipStep);
        CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, centralStorageCity);
        this.append(player, vessel, repairStep);
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, centralStorageCity);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
        this.append(player, vessel, travelTo);
    }

    private ICity getNextStop(ICity city, CentralStorageDeliverMissionData missionData) {
        CentralStorageHintContext context = missionData.getContext();
        List<ICity> supplideCities = context.getSuppliedCities();
        for (int i = 0; i < supplideCities.size(); ++i) {
            ICity currentCity = supplideCities.get(i);
            if (!currentCity.equals(city)) continue;
            if (i == supplideCities.size() - 1) {
                return supplideCities.get(0);
            }
            return supplideCities.get(i + 1);
        }
        return null;
    }

    @VisibleForTesting
    void fillRequiredWaresAvailableBased(Map<IWare, Integer> requiredWares, CentralStorageHintContext context, ITradingOffice office) {
        Arrays.asList(EWare.values()).stream().filter(ware -> context.getWares().contains(ware)).filter(ware -> !office.getSteward().isPresent() || office.getOfficeTrading().isMovableToShip((IWare)ware)).forEach(ware -> {
            int availableInStore = office.getWare((IWare)ware).getAmount();
            requiredWares.put((IWare)ware, availableInStore);
        });
    }

    @VisibleForTesting
    void fillRequiredWaresConsumptionBased(Map<IWare, Integer> requiredWares, CentralStorageHintContext context, CentralStorageDeliverMissionData missionData, IProductionConsumptionKnowledge globalKnowledge) {
        LocalDateTime now = this.date.getCurrentDate();
        int weeks = Math.max(1, (int)(Duration.between(missionData.getLastVisit(), now).toDays() / 7L));
        for (ICity suppliedCity : context.getSuppliedCities()) {
            if (suppliedCity.equals(missionData.getSourceCity())) continue;
            for (IWare ware : context.getWares()) {
                if (!requiredWares.containsKey(ware)) {
                    requiredWares.put(ware, 0);
                }
                ICityProductionConsumptionKnowledge knowledge = globalKnowledge.getKnowlege(suppliedCity);
                int consumption = knowledge.getConsumptionAmount(ware) * weeks;
                requiredWares.put(ware, requiredWares.get(ware) + consumption);
            }
        }
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            CentralStorageDeliverMissionData missionData;
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            ICity city = event.getCity();
            if (city.equals((missionData = (CentralStorageDeliverMissionData)player.getTradeMission(vessel)).getSourceCity())) {
                this.handleTradeInCentralStorage(player, vessel, city, missionData.getContext());
            } else {
                this.handleTradeInSuppliedCity(player, vessel, city, missionData);
            }
            this.executeTradeSteps(player, vessel);
        }
    }

    @VisibleForTesting
    void handleTradeInSuppliedCity(IAIPlayer player, INavigableVessel vessel, ICity city, CentralStorageDeliverMissionData missionData) {
        CentralStorageHintContext context = missionData.getContext();
        IProductionConsumptionKnowledge globalKnowledge = player.getProductionAndConsumptionKnowledge();
        List<ICity> forwardCities = this.calculateForwardCities(city, context);
        LinkedList<ICity> citiesToSell = new LinkedList<ICity>(forwardCities);
        citiesToSell.addFirst(city);
        Map<IWare, Integer> amountToSellOrTransfer = this.calculateAmountsToSell(vessel, city, context, globalKnowledge, citiesToSell);
        Set<IWare> buyWares = this.calculateWaresToBuy(city, context, globalKnowledge);
        boolean sell = true;
        Optional optOffice = player.findTradingOffice(city);
        boolean bl = sell = !optOffice.isPresent() || !((ITradingOffice)optOffice.get()).getSteward().isPresent();
        if (sell) {
            AggregatesCheckedSellTradeStep aggSellStep = this.createAggregatedCheckedSellStep(vessel, city, amountToSellOrTransfer);
            this.append(player, vessel, aggSellStep);
        } else {
            CheckedTransferToOfficeTradeStep transferToOfficeStep = this.createCheckedTransferToOfficeTradeStep(vessel, city, amountToSellOrTransfer);
            this.append(player, vessel, transferToOfficeStep);
        }
        ICity nextStop = this.getNextStop(city, missionData);
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, city);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, city, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, city, player);
        this.append(player, vessel, joinTradeStep);
        HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(city, player);
        this.append(player, vessel, hireTradeManager);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, city);
        this.append(player, vessel, takeLoanStep);
        BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, city);
        this.append(player, vessel, buyWeaponsStep);
        if (!sell) {
            Map<IWare, Integer> buyAmounts = this.calculateBuyAmounts(buyWares);
            TransferToShipTradeStep transfertoShipStep = this.createTransferToShipTradeStep(vessel, city, buyAmounts);
            this.append(player, vessel, transfertoShipStep);
        }
        AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, city, new ArrayList<IWare>(buyWares));
        this.append(player, vessel, buyStepHometown);
        UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
        this.append(player, vessel, upgradeShipStep);
        CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, city);
        this.append(player, vessel, repairStep);
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
        this.append(player, vessel, travelTo);
    }

    @VisibleForTesting
    Map<IWare, Integer> calculateBuyAmounts(Set<IWare> buyWares) {
        HashMap<IWare, Integer> buyAmounts = new HashMap<IWare, Integer>();
        for (IWare buyWare : buyWares) {
            int amount = 5;
            if (buyWare.isBarrelSizedWare()) {
                amount *= 10;
            }
            buyAmounts.put(buyWare, amount);
        }
        return buyAmounts;
    }

    @VisibleForTesting
    Set<IWare> calculateWaresToBuy(ICity city, CentralStorageHintContext context, IProductionConsumptionKnowledge globalKnowledge) {
        HashSet<IWare> buyWares = new HashSet<IWare>();
        for (ICity c : context.getSuppliedCities()) {
            if (c.equals(city)) continue;
            ICityProductionConsumptionKnowledge knowledge = globalKnowledge.getKnowlege(c);
            Arrays.asList(EWare.values()).stream().filter(ware -> knowledge.getConsumptionAmount((IWare)ware) > 0).forEach(ware -> buyWares.add((IWare)ware));
        }
        return buyWares;
    }

    @VisibleForTesting
    Map<IWare, Integer> calculateAmountsToSell(INavigableVessel vessel, ICity city, CentralStorageHintContext context, IProductionConsumptionKnowledge globalKnowledge, List<ICity> cities) {
        HashMap<IWare, Integer> amountToSellOrTransfer = new HashMap<IWare, Integer>();
        for (IWare ware : context.getWares()) {
            double totalConsumedAmount = 0.0;
            for (ICity forwardCity : cities) {
                ICityProductionConsumptionKnowledge knowledge = globalKnowledge.getKnowlege(forwardCity);
                totalConsumedAmount += (double)knowledge.getConsumptionAmount(ware);
            }
            ICityProductionConsumptionKnowledge knowledge = globalKnowledge.getKnowlege(city);
            int consumedHere = knowledge.getConsumptionAmount(ware);
            double percentage = (double)consumedHere / totalConsumedAmount;
            int avalable = vessel.getWare(ware).getAmount();
            int amount = (int)Math.rint((double)avalable * percentage);
            if (amount <= 0) continue;
            amountToSellOrTransfer.put(ware, amount);
        }
        return amountToSellOrTransfer;
    }

    private List<ICity> calculateForwardCities(ICity city, CentralStorageHintContext context) {
        ICity next;
        ArrayList<ICity> forwardCities = new ArrayList<ICity>(context.getSuppliedCities());
        Iterator iterator = forwardCities.iterator();
        while (iterator.hasNext() && !(next = (ICity)iterator.next()).equals(city)) {
            iterator.remove();
        }
        return forwardCities;
    }

    public boolean isSelectable(IAIPlayer player, INavigableVessel vessel) {
        if (player.getFleet().size() < 4) {
            return false;
        }
        List citiesWithTradingOffice = this.map.getAllReachableCities(vessel).stream().filter(city -> player.findTradingOffice(city).isPresent()).collect(Collectors.toList());
        for (ICity city2 : citiesWithTradingOffice) {
            List hints = player.getPlayerContext().getHints(city2);
            for (ITradeStategyHint hint : hints) {
                if (!(hint instanceof CentralStorageStrategyHint)) continue;
                CentralStorageHintContext hintContext = (CentralStorageHintContext)hint.getContext();
                return hintContext.getDistributingVessels().isEmpty();
            }
        }
        return false;
    }
}

