/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.sea.DangerService;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivity;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategy;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class DangerBasedShipUpgradeStrategy
implements IAIShipUpgradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ShipService shipService;
    @Autowired
    private DangerService dangerService;
    @Autowired
    private PirateActivity pirateActivity;
    @Autowired
    private ShipyardEngine shipyardEngine;

    public boolean shouldUpgrade(IShip ship) {
        int nbAttacks;
        if (ship.getShipUpgradeLevel() == EShipUpgrade.LEVEL2) {
            return false;
        }
        int weaponsStrength = this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship);
        List<PirateActivityEntry> attacks = this.pirateActivity.getPirateActivity();
        int observationDuration = this.pirateActivity.getObservationPeriodInDays();
        double twoWeeks = (double)observationDuration / 14.0;
        double attacksInTwoWeeks = twoWeeks / (double)(nbAttacks = this.dangerService.getNumberOfPirateAttacks(attacks));
        if (attacksInTwoWeeks > 1.0 && weaponsStrength < 4) {
            return true;
        }
        return attacksInTwoWeeks > 0.0 && weaponsStrength < 6;
    }

    public void upgrade(IShip ship, ICity city) {
        IShipyard shipyard = city.getCityState().getShipyardState();
        this.shipyardEngine.refitAIShip(shipyard, ship);
        this.logger.debug("Refit vessel {} in {}", (Object)ship.getName(), (Object)city.getName());
    }
}

