/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.BiggestShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownSnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionWaresStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class HometownBiggestShipConstructionSelectionStrategy
extends BiggestShipConstructionSelectionStrategy {
    @Autowired
    private ApplicationContext context;

    public HometownBiggestShipConstructionSelectionStrategy() {
        super(100000, 50, 15000);
    }

    public ICity getBuildLocation(IAIPlayer player) {
        return player.getHometown();
    }

    public void initShipConstruction(IAIPlayer player, INavigableVessel vessel, EShipType shipType) {
        CollectionWaresStrategy strategy = null;
        switch (shipType) {
            case HOLK: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownHolkWareStrategy.class);
                break;
            }
            case COG: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownCogWareStrategy.class);
                break;
            }
            case CRAYER: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownCrayerWareStrategy.class);
                break;
            }
            case SNAIKKA: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownSnaikkaWareStrategy.class);
            }
        }
        strategy.initializeTradeCycle(player, vessel);
    }
}

