/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCityCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCityCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCityHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCitySnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.IAICityDependentShipConstructionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.RandomShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class WestCityRandomShipConstructionSelectionStrategy
extends RandomShipConstructionSelectionStrategy {
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Autowired
    private ApplicationContext context;

    public WestCityRandomShipConstructionSelectionStrategy() {
        super(100000, 50, 15000);
    }

    public ICity getBuildLocation(IAIPlayer player) {
        return player.getHometown();
    }

    public void initShipConstruction(IAIPlayer player, INavigableVessel vessel, EShipType shipType) {
        CollectConstructionWareStrategy strategy = null;
        ICity constructionCity = this.calculateCostructionCity();
        switch (shipType) {
            case HOLK: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionWestCityHolkWareStrategy.class);
                break;
            }
            case COG: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionWestCityCogWareStrategy.class);
                break;
            }
            case CRAYER: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionWestCityCrayerWareStrategy.class);
                break;
            }
            case SNAIKKA: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionWestCitySnaikkaWareStrategy.class);
            }
        }
        ((IAICityDependentShipConstructionStrategy)((Object)strategy)).setConstructionCity(constructionCity);
        strategy.initializeTradeCycle(player, vessel);
    }

    @VisibleForTesting
    ICity calculateCostructionCity() {
        double width = this.map.getDimension().getWidth();
        List chosableCities = this.map.getCities().stream().filter(city -> city.getCoordinates().getX() < width * 0.5).collect(Collectors.toList());
        return (ICity)chosableCities.get(this.rnd.nextInt(chosableCities.size()));
    }
}

