/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class GuildJoinTradeStep
implements ITradeStep {
    private ICity city;
    private IAIPlayer player;
    private INavigableVessel vessel;

    public boolean execute() {
        IAIGuildJoinStrategy strategy = (IAIGuildJoinStrategy)this.player.getGuildJoinStrategyType().getStrategy();
        if (strategy.shouldJoin(this.player, this.city, Optional.ofNullable(this.vessel))) {
            strategy.join(this.player, this.city);
        }
        return true;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setPlayer(IAIPlayer player) {
        this.player = player;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }
}

