/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedBuyTradingOfficeTradeStep;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TradeStepFactory {
    @Autowired
    private ApplicationContext context;

    public AggregatedBuyTradingOfficeTradeStep createAggregatedBuyTradingOfficeTradeStep(ITradingOffice office, ICity city, List<IWare> waresToBuy) {
        AggregatedBuyTradingOfficeTradeStep buyStepHometown = (AggregatedBuyTradingOfficeTradeStep)this.context.getBean(AggregatedBuyTradingOfficeTradeStep.class);
        buyStepHometown.setCity(city);
        buyStepHometown.setTradingOffice(office);
        for (IWare ware : waresToBuy) {
            int maxPrice = ware.getMaxBuyPriceOffensive();
            buyStepHometown.addBuyStep(ware, maxPrice);
        }
        return buyStepHometown;
    }
}

