/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.time;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class DailyUpdateTask
extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.getScheduledDateDailyUpdate());
    }

    private LocalDateTime getScheduledDateDailyUpdate() {
        return this.date.getCurrentDate().plusDays(1L);
    }

    private void scheduleNextDayUpdate() {
        this.taskList.add(this.taskFactory.getPeriodicalDailyUpdateTask());
    }

    public void run() {
        try {
            PeriodicalDailyUpdate evt = new PeriodicalDailyUpdate();
            this.clientServerEventBus.post((Object)evt);
        }
        finally {
            this.scheduleNextDayUpdate();
        }
    }
}

