package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

import java.time.LocalDateTime;

/**
 * Timed task to clear a city event.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Feb 03, 2018
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ClearCityEventTask extends TimedTask {
    private final ICity city;

    public ClearCityEventTask(LocalDateTime executionTime, ICity city) {
        super();
        setExecutionTime(executionTime);
        this.city = city;
    }

    @Override
    public void run() {
        city.getCityState().cityEventProperty().setValue(null);
    }
}
