package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AldermanOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;

import java.time.LocalDateTime;
import java.util.Optional;



/**
 * Task for filing a city violation.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 07, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AddViolationTask extends TimedTask{
    private final ICityViolation violation;
    private final IAldermanOffice office;

    public AddViolationTask(ICityViolation violation, IAldermanOffice office, LocalDateTime electionTime) {
        this.violation = violation;
        this.office = office;
        setExecutionTime(electionTime);
    }

    @Override
    public void run() {
        if (!office.getViolation().isPresent()) {
            ((AldermanOffice)office).setViolation(Optional.of(violation));
        }
    }
}
