package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.engine.EngineFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;

/**
 * Task for the buying the material for the city wall building.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 05, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityWallMaterialBuyingTask extends TimedTask {
    private final ICityHall cityHall;
    @Autowired
    @XStreamOmitField
    private EngineFactory engineFactory;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    @Autowired
    private Date date;
    public CityWallMaterialBuyingTask(ICityHall cityHall, LocalDateTime electionTime) {
        this.cityHall = cityHall;
        setExecutionTime(electionTime);
    }

    /**
     * Check the amount of bricks required and if the price is not too heigh buy it.
     */
    @Override
    public void run() {
        ICity city = cityHall.getCity();
        CityWall cityWall = city.getCityState().getCityWall();
        if (cityWall.getUsedBricks() == cityWall.getBoughtBricks()) {
            int amountRequired = Math.min(10, cityWall.getRequiredBricks() - cityWall.getBoughtBricks());
            int availableAmountCity = city.getWare(EWare.BRICK).getAmount();
            int avgPrice = computablePrice.buyPrice(EWare.BRICK, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amountRequired));
            if (avgPrice < 90) {
                int bought = city.move(EWare.BRICK,-amountRequired, cityHall.getMayor());
                cityWall.setBoughtBricks(cityWall.getBoughtBricks() - bought);
                avgPrice = computablePrice.buyPrice(EWare.BRICK, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(-bought));
                ((Treasury)cityHall.getTreasury()).subtractBuildingCosts(avgPrice * bought);
                LocalDateTime buildDate = date.getCurrentDate().plusDays(5);
                CityWallBuildingTask task = engineFactory.getCityWallBuildingTask(cityWall, buildDate);
                timedTaskListener.add(task);
            }

        }
    }
}
