package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 25, 2016
 */
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.MODEL})
public class CollectWaresMissionData implements ITradeMissionData {
    @Getter
    @Setter
    private ICity city;

    @Getter
    @MapType(key = IWare.class, value = Integer.class)
    private Map<IWare, Integer> requiredWareAmounts = new HashMap<>();

    public void require(IWare ware, int amount) {
        requiredWareAmounts.put(ware, amount);
    }
}
