package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Handle the events triggered by the EventEngine and targeted at an AI player
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 14, 2016
 */
public interface IAIEventHandler {
    /**
     * Handle the offer of a marriage broker.
      * @param state
     */
    void handleMarriageEvent(IAIPlayer player, MarriageBrokerAnnouncementState state);
    /**
     * Method to handle the initializing of a trade strategy for a new ship.
     * @param ship
     * @param player
     */
    void initializeNewShip(IShip ship, IAIPlayer player);
}
