package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.engine.player.strategy.SupplyHometownAIStrategy;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * The mission data for the {@link SupplyHometownAIStrategy} stores the
 * wares that should be delivered to the hometown in the current cyle
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on May 22, 2016
 */
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.MODEL})
public class SupplyCityMissionData implements ITradeMissionData {
    @Getter
    @Setter
    @ListType(IWare.class)
    private List<IWare> requiredWares;
    @Getter
    @Setter
    private ICity targetCity;

}
