package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.ship.EShipType;

/**
 * Strategy to collect wares to construct a cog.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 26, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CollectConstructionHometownCogWareStrategy extends CollectionConstructionHometownWaresStrategy {
    public CollectConstructionHometownCogWareStrategy() {
        super(EShipType.COG);
    }

    @Override
    protected IAITradeStrategyType getStrategyType() {
        return ECollectWareStrategyType.HOMETOWN_COG;
    }
}
