package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Random;

import static java.util.stream.Collectors.toList;

/**
 * This implementation for construction provides construction location in a random city in the west.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 30, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public abstract class CollectionConstructionWestCityWaresStrategy extends CollectConstructionWareStrategy implements IAICityDependentShipConstructionStrategy {
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Setter
    private ICity constructionCity;

    public CollectionConstructionWestCityWaresStrategy(EShipType constructionType) {
        super(constructionType);
    }

    @Override
    protected ICity getConstructionCity(IAIPlayer player) {
        return constructionCity;
    }
}
