package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 04, 2017
 */
public enum EUpgradeShipStrategyTypes implements IAIShipUpgradeStrategyType {
    DANGER_BASED_UPGRADE(DangerBasedShipUpgradeStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIShipUpgradeStrategy> strategyClass;

    EUpgradeShipStrategyTypes(Class<? extends IAIShipUpgradeStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIShipUpgradeStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
