package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Strategy to never hire a captain.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class HireCaptainNeverStrategy extends BaseHireCaptainStrategy {
    @Override
    public boolean shouldHire(IAIPlayer player, IShip vessel, ICity city) {
        return false;
    }
}
