package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.city.EKontorType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;

/**
 * Repair strategy defines only repairs in cities of kontor type Kontor.
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class KontorTypeCityRepairStrategy extends BaseRepairStrategy {
    /**
     * Unless the damage is quite heavy repares are only conducted in cities of type Kontor.
     * @param vessel that should be checked for repair need.
     * @param city current possition of the vessel.
     * @return
     */
    @Override
    public boolean shouldRepair(INavigableVessel vessel, ICity city) {
        Preconditions.checkArgument(vessel.getLocation().equals(city.getCoordinates()), "The vessel is not in city "+city.getName()+" but at "+vessel.getLocation());
        int damage = vessel.getDamage();
        if (damage > 90) {
            return true;
        }
        if (city.getKontorType() == EKontorType.KONTOR) {
            return true;
        }

        return false;
    }
}
