package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;

/**
 * This event decision strategy is based on the available cash amount.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 18, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class MoneyBasedEventDecisionStrategy implements IAIEventDecisionStrategy {
    @Override
    public boolean acceptMarriagBrokereOffer(IAIPlayer player) {
        if (!player.getSpouseData().isPresent()) {
            long cash = player.getCompany().getCash();
            return cash > 100000;
        }
        return false;
    }

    @Override
    public boolean acceptMarriageOffer(IAIPlayer player) {
        return acceptMarriagBrokereOffer(player);
    }

    @Override
    public boolean shouldOrderCelebration(IAIPlayer player, ICity city) {
        long cash = player.getCompany().getCash();
        return cash > 100000;
    }
}
