package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/**
 * Base strategy to build the bigest possible ships at a given location.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 27, 2017
 */
public abstract class RandomShipConstructionSelectionStrategy extends BaseShipConstructionSelectionStrategy {
    @Autowired
    private Random rnd;
    public RandomShipConstructionSelectionStrategy(int minCash, int maxFeetSize, int maxTotalCargoCapacity) {
        super(minCash, maxFeetSize, maxTotalCargoCapacity);
    }

    @Override
    public EShipType shouldBuildShipType(IAIPlayer player) {
        // Which ships can be built in town
        ICity where = getBuildLocation(player);
        List<EShipType> shipTypes = new ArrayList<>(Arrays.asList(where.getCityState().getShipyardState().getBuildableShipTypes()));
        return shipTypes.get(rnd.nextInt(shipTypes.size()));
    }
}
