package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

import java.util.Optional;

/**
 * Always join the guild if the player has a certain amount of cash dependent on the entry fee.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 15, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class TradingOfficeJoinGuildMinCashStrategy extends BaseJoinGuildStrategy {

    @Override
    protected boolean additionalJoinRequirementsMet(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel) {
        Optional<ITradingOffice> optTradingOffice = player.findTradingOffice(city);
        return optTradingOffice.isPresent();
    }
}
