/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event;

import ch.sahits.game.openpatrician.engine.event.EEventState;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class EventEngineState {
    @MapType(key=ICity.class, value=LocalDateTime.class)
    private Map<ICity, LocalDateTime> lastFire = new HashMap<ICity, LocalDateTime>();
    @MapType(key=ICity.class, value=LocalDateTime.class)
    private Map<ICity, LocalDateTime> lastPlague = new HashMap<ICity, LocalDateTime>();
    @MapType(key=String.class, value=EEventState.class)
    private Map<String, EEventState> marriageState = new HashMap<String, EEventState>();

    public void addFire(ICity city, LocalDateTime date) {
        this.lastFire.put(city, date);
    }

    public Optional<LocalDateTime> getLastFire(ICity city) {
        return Optional.ofNullable(this.lastFire.get(city));
    }

    public void addPlague(ICity city, LocalDateTime date) {
        this.lastPlague.put(city, date);
    }

    public Optional<LocalDateTime> getLastPlague(ICity city) {
        return Optional.ofNullable(this.lastPlague.get(city));
    }

    public void setMarriageState(IPlayer player, EEventState state) {
        this.marriageState.put(player.getUuid(), state);
    }

    public Optional<EEventState> getMarriageState(IPlayer player) {
        return Optional.ofNullable(this.marriageState.get(player.getUuid()));
    }

    public void resetMarriedState(IPlayer player) {
        this.marriageState.remove(player.getUuid());
    }
}

