/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageOfferState;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.task.MarriageTask;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectCelebrationWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedBuyTradingOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TradeStepFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageOfferTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    private StateFactory stateFactory;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @XStreamOmitField
    private TradeStepFactory tradeStepFactory;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    private IAIPlayer player;
    private MarriageBrokerAnnouncementState state;
    private LocalDateTime deadLine;

    public MarriageOfferTask(IAIPlayer player, MarriageBrokerAnnouncementState state, LocalDateTime deadLine) {
        this.player = player;
        this.state = state;
        this.deadLine = deadLine;
        this.setExecutionTime(deadLine);
    }

    public void run() {
        ISpouseData spouse = this.stateFactory.createSpouse(this.state, (IPlayer)this.player);
        MarriageOfferState marriageOffer = MarriageOfferState.builder().date(this.deadLine).fromFirstName(this.state.getFromFirstName()).fromLastName(this.state.getFromLastName()).location(this.state.getLocation()).player((IPlayer)this.player).tillDate(this.deadLine.plusDays(30L)).spouse(spouse).build();
        this.handleMarriageOffer(this.player, marriageOffer);
    }

    private void handleMarriageOffer(IAIPlayer player, MarriageOfferState offer) {
        ICity hometown = player.getHometown();
        Optional optOffice = player.findTradingOffice(hometown);
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)"In the hometown a trading office is required");
        ITradingOffice office = (ITradingOffice)optOffice.get();
        List<IWare> wares = Arrays.asList(EWare.BEER, EWare.WINE, EWare.GRAIN, EWare.MEAT, EWare.FISH, EWare.HONEY);
        AggregatedBuyTradingOfficeTradeStep buy = this.tradeStepFactory.createAggregatedBuyTradingOfficeTradeStep(office, hometown, wares);
        buy.execute();
        INavigableVessel nearestVessel = (INavigableVessel)player.getFleet().get(0);
        double minDistance = Double.MAX_VALUE;
        Point2D coord = hometown.getCoordinates();
        for (INavigableVessel vessel : player.getSelectableVessels()) {
            double distance = vessel.getLocation().distance(coord);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestVessel = vessel;
        }
        CollectCelebrationWaresStrategy strategy = (CollectCelebrationWaresStrategy)this.context.getBean(CollectCelebrationWaresStrategy.class);
        strategy.setCelebrationLocation(hometown);
        strategy.initializeTradeCycle(player, nearestVessel);
        player.updateTradeWaitingStatus(nearestVessel, false);
        LocalDateTime weddingDate = this.date.getCurrentDate().plusDays(21L);
        MarriageTask task = this.taskFactory.getMarriageCelebrationEvent(weddingDate, (IPlayer)player, hometown, offer.getSpouse());
        this.taskList.add((TimedTask)task);
    }
}

