/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class RefitShipTask
extends TimedTask {
    private final IShip ship;
    private final EShipUpgrade level;
    protected final ICityPlayerProxyJFX city;
    private final IShipyard shipyard;
    @Autowired
    @XStreamOmitField
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;

    public RefitShipTask(LocalDateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX city, IShipyard shipyard) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
        this.level = upgrade;
        this.city = city;
        this.shipyard = shipyard;
    }

    public void run() {
        EShipUpgrade currentLevel = this.ship.getShipUpgradeLevel();
        while (currentLevel != this.level) {
            this.ship.upgrade();
            List oldWeaponSlots = this.ship.getWeaponSlots();
            List newWeaponSlots = this.shipWeaponLocationFactory.getShipWeaponsLocation(this.ship.getShipType(), this.level);
            this.ship.setWeaponSlots(newWeaponSlots);
            for (IWeaponSlot slot : oldWeaponSlots) {
                if (!slot.getWeapon().isPresent()) continue;
                EWeapon weapon = (EWeapon)slot.getWeapon().get();
                if (slot instanceof SecondaryLargeWeaponSlot) {
                    if (this.shipService.isLargeWeapon(weapon)) continue;
                    this.shipService.placeWeapon(weapon, this.ship);
                    continue;
                }
                this.shipService.placeWeapon(weapon, this.ship);
            }
            currentLevel = this.ship.getShipUpgradeLevel();
        }
        this.ship.setAvailable(true);
        this.city.getPlayersShips().add((Object)this.ship);
        this.shipyard.removeCompletedUpgrade(this.ship);
        if (this.city.getPlayersShips().size() == 1) {
            this.city.activateShip((INavigableVessel)this.ship);
        }
        int currentCapacity = this.ship.getCapacity();
        if (this.ship.getOwner() instanceof IHumanPlayer) {
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message", new Object[]{this.ship.getShipType(), this.level, currentCapacity});
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)this.ship.getOwner(), (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }
}

