/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.CaptainEngine;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.AUpdatableCityRelated;
import ch.sahits.game.openpatrician.model.AmountableProvider;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.collection.CityTavernRegistry;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.javafx.bindings.StaticIntegerBinding;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.IBaseTraveler;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TavernEngine
extends AbstractEngine {
    @Autowired
    private Random rnd;
    @Value(value="${beggar.salior.ratio}")
    private int beggarSailorRation;
    @Autowired
    private CaptainEngine captainEngine;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private CityTavernRegistry cities;
    @Autowired
    private MapService cityUtils;
    @Autowired
    private IMap map;
    @Autowired
    private Date date;
    @Autowired
    private SeaPiratesState pirateState;
    @Autowired
    private CitiesState cityState;
    @Autowired
    private AIPlayerList aiPlayers;
    @Autowired
    private ComputablePriceV2 computablePrice;
    @Autowired
    private AmountableProvider amountableProvider;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");
    private static RandomNameLoader pirateFirstNameLoader = new RandomNameLoader("pirate_firstnames.properties");
    private static RandomNameLoader pirateLastNameLoader = new RandomNameLoader("pirate_lastnames.properties");

    public void addCity(TavernState state, ICity city) {
        this.cities.put((Object)city, (Object)state);
        int nbSailors = this.computeNumbersOfSailors(city);
        ISailorState sailors = state.getSailors();
        sailors.setNumberOfSailors(nbSailors);
        this.handlePersonsBecomingAbsent(state);
        this.handlePersonsBecomingPresent(city, state);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList((Object[])new AbstractEngine[]{this.captainEngine});
    }

    @PostConstruct
    private void init() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    private int computeNumbersOfSailors(ICity city) {
        int nbBeggars = city.getPopulation(EPopulationClass.BEGGAR);
        int nbSailors = (int)((double)(nbBeggars / this.beggarSailorRation) * this.rnd.nextDouble() * 2.0);
        return nbSailors;
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        for (Map.Entry entry : this.cities.entrySet()) {
            ICity city = (ICity)entry.getKey();
            TavernState state = (TavernState)entry.getValue();
            int nbSailors = this.computeNumbersOfSailors(city);
            state.getSailors().setNumberOfSailors(nbSailors);
            this.handlePersonsBecomingAbsent(state);
            this.handlePersonsBecomingPresent(city, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePersonsBecomingAbsent(TavernState state) {
        ObservableList present = state.presentPersonsProperty();
        ArrayList leavingPersons = Lists.newArrayList();
        for (IPerson p : present) {
            if (!(p instanceof ITavernPerson)) continue;
            ITavernPerson person = (ITavernPerson)p;
            double maxPresence = Math.abs(person.getMaxDaysPresent());
            double presenceTime = Math.abs(person.getNumberOfDaysSinceArrival());
            double absence = this.rnd.nextDouble() * presenceTime / maxPresence;
            if (!(absence > 0.75)) continue;
            leavingPersons.add(person);
        }
        TavernState tavernState = state;
        synchronized (tavernState) {
            for (ITavernPerson person : leavingPersons) {
                person.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePersonsBecomingPresent(ICity city, TavernState state) {
        ObservableList absent = state.absentPersonProperty();
        ArrayList arrivingPersons = Lists.newArrayList();
        for (ITavernPerson person : absent) {
            double maxPresence = Math.abs(person.getMaxDaysPresent());
            double maxNbAbsence = Math.abs(person.getMaxDaysAbsent());
            double absentTime = (double)person.getNumberOfDaysSinceArrival() - maxPresence;
            double presence = this.rnd.nextDouble() * 2.0 * (absentTime / maxNbAbsence);
            if (!(presence > 0.5)) continue;
            this.updateCityRelatedPersons(person, city);
            this.updatePersons(person);
            arrivingPersons.add(person);
        }
        TavernState tavernState = state;
        synchronized (tavernState) {
            for (ITavernPerson person : arrivingPersons) {
                person.arrive();
            }
        }
    }

    @VisibleForTesting
    void updatePersons(ITavernPerson person) {
        if (this.isAnnotatedType(person, AUpdatable.class)) {
            if (person instanceof IBuyer) {
                IBuyer buyer = (IBuyer)person;
                buyer.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                int days = this.rnd.nextInt(5);
                buyer.setDeadline(this.date.getCurrentDate().plusDays(5 + days));
                int wareIndex = this.rnd.nextInt(EWare.values().length);
                EWare ware = EWare.values()[wareIndex];
                buyer.setWare((IWare)ware);
                int amount = this.rnd.nextInt(21) + 3;
                int price = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(5), (IntegerBinding)new StaticIntegerBinding(amount));
                AmountablePrice amt = this.amountableProvider.createWareAmountable();
                amt.add(amount, price);
                buyer.setAmountablePrice(amt);
            } else if (person instanceof IWarehouseTenant) {
                IWarehouseTenant tenant = (IWarehouseTenant)person;
                tenant.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                tenant.setAmount(this.rnd.nextInt(800) + 100);
            } else if (person instanceof IInformant) {
                boolean noInformationYet;
                IInformant informant = (IInformant)person;
                int val = this.rnd.nextInt(2);
                informant.setShowMapIfAvailable(this.rnd.nextInt(3) == 0);
                informant.setPrice(this.rnd.nextInt(1000) + 120);
                this.updateWareNeedOrSurplus(val, informant);
                int nextVal = this.rnd.nextInt(2);
                if (val != nextVal) {
                    this.updateWareNeedOrSurplus(nextVal, informant);
                }
                boolean bl = noInformationYet = !informant.getWareNeeded().isPresent() && !informant.getWareSurplus().isPresent();
                if (this.rnd.nextBoolean() || noInformationYet) {
                    ISeaPirate pirate = this.pirateState.findSuccessfulPirate();
                    ICity nearest = this.cityUtils.findNearestCity(pirate.getShip().getLocation());
                    informant.setPirateLocation(pirate, nearest);
                }
            } else if (person instanceof IConcurrent) {
                IConcurrent concurrent = (IConcurrent)person;
                List players = this.aiPlayers.getAll();
                int index = this.rnd.nextInt(players.size());
                IPlayer p1 = (IPlayer)players.get(index);
                int other = this.rnd.nextInt(players.size());
                while (other == index) {
                    other = this.rnd.nextInt(players.size());
                }
                IPlayer p2 = (IPlayer)players.get(other);
                concurrent.setClientPlayer(p1);
                concurrent.setConcurrentPlayer(p2);
                concurrent.setPremium(this.rnd.nextInt(8500) + 1500);
            } else if (person instanceof IContractBroker) {
                IContractBroker broker = (IContractBroker)person;
                broker.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
            } else if (person instanceof ITreasureMapOwner) {
                ITreasureMapOwner owner = (ITreasureMapOwner)person;
                owner.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                owner.setPrice(this.rnd.nextInt(1500) + 1000);
            } else if (person instanceof IThieve) {
                IThieve thieve = (IThieve)person;
                thieve.setPrice(this.rnd.nextInt(400) + 100);
            } else if (person instanceof IPirate) {
                IPirate pirate = (IPirate)person;
                pirate.setName(pirateFirstNameLoader.getRandomName() + " " + pirateLastNameLoader.getRandomName());
                pirate.setFollowers(this.rnd.nextInt(15) + 12);
                pirate.setProfitShare((double)(this.rnd.nextInt(7) * 5 + 35) / 100.0);
            } else if (person instanceof IPirateHunter) {
                IPirateHunter hunter = (IPirateHunter)person;
                hunter.setClientName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                hunter.setPirateName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                hunter.setPremium(this.rnd.nextInt(5000) + 1434);
            }
        }
    }

    private void updateWareNeedOrSurplus(int val, IInformant informant) {
        switch (val) {
            case 0: {
                Optional missing = this.cityState.findCityWithMostNeededWare();
                if (!missing.isPresent()) break;
                GenericPair pair = (GenericPair)missing.get();
                informant.setNeededWare((ICity)pair.getFirst(), (IWare)pair.getSecond());
                break;
            }
            case 1: {
                Optional surplus = this.cityState.findCityWithSurplusWare();
                if (!surplus.isPresent()) break;
                GenericPair pair = (GenericPair)surplus.get();
                informant.setWareSurplus((ICity)pair.getFirst(), (IWare)pair.getSecond());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid random number: " + val);
            }
        }
    }

    @VisibleForTesting
    void updateCityRelatedPersons(ITavernPerson person, ICity city) {
        if (this.isAnnotatedType(person, AUpdatableCityRelated.class)) {
            if (person instanceof ICourier) {
                ICourier courier = (ICourier)person;
                courier.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                courier.setPremium(this.rnd.nextInt(2000) + 4300);
                int nbDestinations = this.rnd.nextInt(3) + 3;
                ICity[] destinations = new ICity[nbDestinations];
                courier.setDestinations(destinations);
                this.fillDestinations(city, destinations);
                courier.setCurrentDestIndex(0);
            } else if (person instanceof ITransportTrader) {
                ITransportTrader transportTrader = (ITransportTrader)person;
                transportTrader.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                transportTrader.setPremium(this.rnd.nextInt(700) + 300);
                transportTrader.setNeededCapacity(this.rnd.nextInt(40) + 4);
                ArrayList<ICity> visited = new ArrayList<ICity>();
                visited.add(city);
                ICity next = this.cityUtils.findNearbyCityRepeated(city, 1.0, 1024, visited);
                transportTrader.setDestination(next);
            } else if (person instanceof ITrader) {
                ITrader trader = (ITrader)person;
                EWare ware = EWare.values()[this.rnd.nextInt(EWare.values().length)];
                AmountablePrice amountablePrice = city.getWare((IWare)ware);
                int availableAmount = amountablePrice.getAmount();
                while (availableAmount == 0) {
                    ware = EWare.values()[this.rnd.nextInt(EWare.values().length)];
                    availableAmount = city.getWare((IWare)ware).getAmount();
                }
                int amount = ware.getSizeAsBarrels() == 1 ? this.rnd.nextInt(100) : this.rnd.nextInt(20);
                amount = Math.max(1, amount);
                trader.setAmount(amount);
                double variance = this.rnd.nextDouble() * 0.25 - 0.125;
                int newPrice = (int)Math.abs(Math.rint(variance * (double)this.computablePrice.sellPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new StaticIntegerBinding(amount))));
                trader.setAvgPricePerItem(newPrice);
                trader.setWare((IWare)ware);
            } else if (person instanceof ISmuggler) {
                ISmuggler smuggler = (ISmuggler)person;
                smuggler.setAmount(this.rnd.nextInt(200) + 16);
                smuggler.setPremium(this.rnd.nextInt(1000) + 180);
                List cities = this.map.getCities();
                ICity nextCity = (ICity)cities.get(this.rnd.nextInt(cities.size()));
                while (nextCity.equals(city)) {
                    nextCity = (ICity)cities.get(this.rnd.nextInt(cities.size()));
                }
                smuggler.setDestination(nextCity);
            } else if (person instanceof IPatrol) {
                IPatrol patrol = (IPatrol)person;
                patrol.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
                patrol.setPremium(this.rnd.nextInt(2000) + 4300);
                patrol.setBonus(this.rnd.nextInt(2000) + 2000);
                ICity[] destinations = new ICity[3];
                patrol.setDestinations(destinations);
                this.fillDestinations(city, destinations);
                patrol.setCurrentDestIndex(0);
            } else if (person instanceof IBaseTraveler) {
                int premium = this.rnd.nextInt(1543) + 324;
                ((IBaseTraveler)person).setPremium(premium);
                ICity destination = this.cityUtils.findRandomCity(city);
                Preconditions.checkNotNull((Object)destination);
                ((IBaseTraveler)person).setDestination(destination);
            }
        }
    }

    private void fillDestinations(ICity city, ICity[] destinations) {
        ArrayList<ICity> visited = new ArrayList<ICity>();
        visited.add(city);
        ICity curCity = city;
        for (int i = 0; i < destinations.length; ++i) {
            ICity next;
            destinations[i] = next = this.cityUtils.findNearbyCityRepeated(curCity, 0.2, 1024, visited);
            visited.add(next);
            curCity = next;
        }
    }

    private boolean isAnnotatedType(ITavernPerson person, Class annotation) {
        return person.getClass().getAnnotation(annotation) != null;
    }
}

