/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.MapProxy;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.SupplyCityMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageHintContext;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageStrategyHint;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.ITradeStategyHint;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class SupplyCentralTradingStationAIStrategy
extends BasePlayerTradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private MapProxy map;
    @Autowired
    private MapService mapService;
    @Autowired
    private ShipService shipService;

    public SupplyCentralTradingStationAIStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.COLLECT_WARES_FOR_STORAGE_LOCATION;
    }

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        Pair<ICity, CentralStorageStrategyHint> setup = this.setupContextHint(player, vessel);
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        CentralStorageHintContext context = (CentralStorageHintContext)((CentralStorageStrategyHint)setup.getValue()).getContext();
        SupplyCityMissionData missionData = new SupplyCityMissionData();
        missionData.setRequiredWares(new ArrayList<IWare>(context.getWares()));
        missionData.setTargetCity((ICity)setup.getKey());
        player.setTradeMission(vessel, (ITradeMissionData)missionData);
        Optional locatedInCity = this.shipService.findCity(vessel);
        if (!locatedInCity.isPresent() || !((ICity)locatedInCity.get()).equals(setup.getKey())) {
            if (!locatedInCity.isPresent()) {
                ICity city = this.findCitySupplingWares(player, vessel, context);
                TravelToTradeStep travelTo = this.createTravelToStep(vessel, city);
                this.append(player, vessel, travelTo);
            } else {
                this.addDefaultTradeSteps(vessel, player, (ICity)locatedInCity.get(), (ICity)setup.getKey(), context.getWares(), context.getWares(), false);
            }
        } else {
            ICity city = this.findCitySupplingWares(player, vessel, context);
            List<Pair<IWare, Number>> neededWares = this.getMostNeededWares(knowledge.getKnowlege(city), vessel);
            HashSet<IWare> wares = new HashSet<IWare>();
            neededWares.stream().forEach(pair -> wares.add((IWare)pair.getKey()));
            this.addDefaultTradeSteps(vessel, player, (ICity)locatedInCity.get(), city, context.getWares(), wares, false);
        }
    }

    private ICity findCitySupplingWares(IAIPlayer player, INavigableVessel vessel, CentralStorageHintContext context) {
        HashSet<ICity> excludeCity = new HashSet<ICity>(context.getSuppliedCities());
        Optional<ICity> optCity = this.findCityWithAllRequiredWares(new ArrayList<IWare>(context.getWares()), player, vessel, excludeCity);
        ICity city = optCity.isPresent() ? optCity.get() : this.findCitySupplyingWare(player, context.getWares().iterator().next(), vessel, excludeCity);
        return city;
    }

    Pair<ICity, CentralStorageStrategyHint> setupContextHint(IAIPlayer player, INavigableVessel vessel) {
        List citiesWithTradingOffice = this.map.getAllReachableCities(vessel).stream().filter(city -> player.findTradingOffice(city).isPresent()).collect(Collectors.toList());
        Collections.shuffle(citiesWithTradingOffice);
        ICity targetCity = null;
        CentralStorageStrategyHint hint = null;
        for (ICity city2 : citiesWithTradingOffice) {
            if (targetCity != null) break;
            List hints = player.getPlayerContext().getHints(city2);
            for (ITradeStategyHint h : hints) {
                if (targetCity != null) break;
                if (!(h instanceof CentralStorageStrategyHint)) continue;
                hint = (CentralStorageStrategyHint)h;
                CentralStorageHintContext hintContext = (CentralStorageHintContext)h.getContext();
                if (!hintContext.getSupplyingVessels().isEmpty()) break;
                hintContext.addSupplyingVessel(vessel);
                targetCity = city2;
                break;
            }
            if (targetCity != null) break;
            hint = new CentralStorageStrategyHint();
            CentralStorageHintContext context = new CentralStorageHintContext();
            context.addSupplyingVessel(vessel);
            hint.setContext(context);
            player.getPlayerContext().add(city2, (ITradeStategyHint)hint);
            targetCity = city2;
            ArrayList<ICity> suppliedCities = new ArrayList<ICity>();
            suppliedCities.add(city2);
            ICity nextCity = null;
            List excludeCities = this.map.getAllUnreachableCities(vessel);
            excludeCities.add(city2);
            for (int i = 0; i < 3 && (nextCity = this.mapService.findNearbyCityRepeated(city2, 1.0, 500, excludeCities)) != null; ++i) {
                suppliedCities.add(nextCity);
                excludeCities.add(nextCity);
            }
            suppliedCities.stream().forEach(c -> context.addSuppliedCity((ICity)c));
            ArrayList<EWare> consumed = new ArrayList<EWare>();
            ArrayList<EWare> produced = new ArrayList<EWare>();
            IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
            for (ICity suppliedCity : suppliedCities) {
                ICityProductionConsumptionKnowledge cityKnowledge = knowledge.getKnowlege(suppliedCity);
                for (EWare ware2 : EWare.values()) {
                    int producedAmount = cityKnowledge.getProductionAmount((IWare)ware2);
                    int consumedAmount = cityKnowledge.getConsumptionAmount((IWare)ware2);
                    if (producedAmount > 0 && !produced.contains(ware2)) {
                        produced.add(ware2);
                    }
                    if (consumedAmount <= 0 || consumed.contains(ware2)) continue;
                    consumed.add(ware2);
                }
            }
            ArrayList requiredWares = new ArrayList(consumed);
            requiredWares.removeAll(produced);
            requiredWares.stream().forEach(ware -> context.addWare((IWare)ware));
            player.getPlayerContext().add(city2, (ITradeStategyHint)hint);
        }
        return new Pair(targetCity, hint);
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            ICity city = event.getCity();
            SupplyCityMissionData missionData = (SupplyCityMissionData)player.getTradeMission(vessel);
            ICity targetCity = missionData.getTargetCity();
            CentralStorageStrategyHint hint = (CentralStorageStrategyHint)player.getPlayerContext().getHints(targetCity).stream().filter(h -> h instanceof CentralStorageStrategyHint).findFirst().get();
            CentralStorageHintContext context = (CentralStorageHintContext)hint.getContext();
            if (city.equals(targetCity)) {
                TransferToOfficeTradeStep transferToOfficeStep = this.createTransferToOfficeTradeStep(vessel, city);
                this.append(player, vessel, transferToOfficeStep);
                ICity nextStop = this.findProvidingWares(city, context.getWares(), context.getSuppliedCities(), player, vessel);
                ICityProductionConsumptionKnowledge cityKnowledge = player.getProductionAndConsumptionKnowledge().getKnowlege(nextStop);
                List<Pair<IWare, Number>> needs = this.getMostNeededWares(cityKnowledge, vessel);
                HashSet<IWare> buyWares = new HashSet<IWare>();
                needs.stream().forEach(pair -> buyWares.add((IWare)pair.getKey()));
                buyWares.removeAll(context.getWares());
                this.addDefaultTradeSteps(vessel, player, city, nextStop, new HashSet<IWare>(context.getWares()), buyWares, false);
            } else {
                this.addDefaultTradeSteps(vessel, player, city, targetCity, new HashSet<IWare>(context.getWares()), new HashSet<IWare>(context.getWares()), false);
            }
            this.executeTradeSteps(player, vessel);
        }
    }

    public boolean isSelectable(IAIPlayer player, INavigableVessel vessel) {
        if (player.getFleet().size() < 4) {
            return false;
        }
        List citiesWithTradingOffice = this.map.getAllReachableCities(vessel).stream().filter(city -> player.findTradingOffice(city).isPresent()).collect(Collectors.toList());
        Iterator iterator = citiesWithTradingOffice.iterator();
        if (iterator.hasNext()) {
            ICity city2 = (ICity)iterator.next();
            List hints = player.getPlayerContext().getHints(city2);
            for (ITradeStategyHint hint : hints) {
                if (!(hint instanceof CentralStorageStrategyHint)) continue;
                CentralStorageHintContext hintContext = (CentralStorageHintContext)hint.getContext();
                return hintContext.getSupplyingVessels().isEmpty();
            }
            return true;
        }
        return false;
    }
}

