/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradingOfficeTradeStep;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class AggregatedBuyTradingOfficeTradeStep
implements ITradeStep {
    private ICity city;
    private ITradingOffice tradingOffice;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(value=BuyTradingOfficeTradeStep.class)
    private ArrayList<BuyTradingOfficeTradeStep> tradeSteps = new ArrayList();

    public void addBuyStep(IWare ware, int maxPrice) {
        BuyTradingOfficeTradeStep buyStep = (BuyTradingOfficeTradeStep)this.context.getBean(BuyTradingOfficeTradeStep.class);
        buyStep.setMaxBuyPrice(maxPrice);
        buyStep.setCity(this.city);
        buyStep.setTradingOffice(this.tradingOffice);
        buyStep.setWare(ware);
        this.tradeSteps.add(buyStep);
    }

    private List<BuyTradingOfficeTradeStep> getPriorityList() {
        ArrayList<BuyTradingOfficeTradeStep> list = new ArrayList<BuyTradingOfficeTradeStep>();
        HashMap<BuyTradingOfficeTradeStep, Integer> loadedWares = new HashMap<BuyTradingOfficeTradeStep, Integer>();
        for (BuyTradingOfficeTradeStep step : this.tradeSteps) {
            IWare ware = step.getWare();
            int amount = this.tradingOffice.getWare(ware).getAmount();
            loadedWares.put(step, amount);
        }
        loadedWares.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> list.add((BuyTradingOfficeTradeStep)entry.getKey()));
        return list;
    }

    public boolean execute() {
        List<BuyTradingOfficeTradeStep> priorityList = this.getPriorityList();
        for (BuyTradingOfficeTradeStep buyTradeStep : priorityList) {
            buyTradeStep.execute();
            if (this.tradingOffice.capacityProperty().get() - this.tradingOffice.getOccupiedSpace() != 0) continue;
            break;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return "AggregatedBuyTradingOfficeTradeStep in " + this.city.getName() + " buying: " + sb.toString().toString();
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setTradingOffice(ITradingOffice tradingOffice) {
        this.tradingOffice = tradingOffice;
    }
}

