/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckHireCaptainTradeStep
implements ITradeStep {
    private ICity city;
    private IAIPlayer player;
    private INavigableVessel vessel;

    public boolean execute() {
        Optional captain;
        IAICaptainHireStrategy strategy = (IAICaptainHireStrategy)this.player.getCaptainHireStrategyType().getStrategy();
        IShip ship = null;
        if (this.vessel instanceof IShipGroup) {
            return true;
        }
        if (this.vessel instanceof IShip) {
            ship = (IShip)this.vessel;
        }
        if (this.vessel instanceof IConvoy) {
            ship = ((IConvoy)this.vessel).getOrlegShip();
        }
        if (strategy.shouldHire(this.player, ship, this.city) && (captain = strategy.getCaptain(this.city)).isPresent()) {
            strategy.hire(this.player, ship, (ICaptain)captain.get(), this.city);
        }
        return true;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setPlayer(IAIPlayer player) {
        this.player = player;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }
}

