/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckedTransferToOfficeTradeStep
implements ITradeStep {
    private ICity city;
    private INavigableVessel vessel;
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> transferAmounts;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    public boolean execute() {
        ITradingOffice office;
        IAIPlayer player = (IAIPlayer)this.vessel.getOwner();
        Optional optOffice = player.findTradingOffice(this.city);
        if (optOffice.isPresent() && (office = (ITradingOffice)optOffice.get()).getSteward().isPresent()) {
            List neededWares = this.tradeService.getBasicNeeds();
            List transferableWares = this.vessel.getLoadedWares().stream().filter(ware -> neededWares.contains(ware)).collect(Collectors.toList());
            HashMap<IWare, Integer> map = new HashMap<IWare, Integer>();
            for (IWare ware2 : transferableWares) {
                int amount = this.vessel.getWare(ware2).getAmount();
                if (ware2.isBarrelSizedWare()) {
                    amount *= 10;
                }
                int availableSpace = office.capacityProperty().get();
                int movableAmount = Math.min(Math.min(availableSpace, amount), this.transferAmounts.get(ware2));
                map.put(ware2, movableAmount);
            }
            if (!map.isEmpty()) {
                this.tradeService.transferFromVesselToStorage(this.vessel, (IPlayer)player, this.city, map);
            }
        }
        return true;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setTransferAmounts(Map<IWare, Integer> transferAmounts) {
        this.transferAmounts = transferAmounts;
    }
}

