/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.engine.sea.BaseGraphCalulationService;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.HeuristicGraphInitialisationComplete;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.carrotsearch.hppc.ObjectDoubleMap;
import com.carrotsearch.hppc.ObjectDoubleScatterMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class AStarHeuristicProvider
extends BaseGraphCalulationService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverThreadPool")
    private ExecutorService serverThreadPool;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final Object lock = new Object();
    @MapType(key=Point2D.class, value=Map.class)
    private final Map<Point2D, ObjectDoubleMap<Point2D>> heuristicMap = new ConcurrentHashMap<Point2D, ObjectDoubleMap<Point2D>>();
    private int width;
    private int height;
    private boolean initializing = false;

    @PostConstruct
    private void initialize() {
        this.initializing = true;
        try {
            this.initImage();
            this.serverThreadPool.execute(() -> this.createGraph());
        }
        catch (IOException e) {
            this.logger.error("Failed to create black and white image from the map", (Throwable)e);
            this.initializing = false;
        }
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void registerGameLoad(GameStateChange gameStateChange) {
        if (!this.initializing && gameStateChange.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            this.logger.info("Initialize heuristic after game load.");
            this.initialize();
        }
    }

    @VisibleForTesting
    void initImage() throws IOException {
        this.width = this.imageService.getWidth();
        this.height = this.imageService.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createGraph() {
        long timestamp = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            List cities = this.map.getCities();
            for (ICity city : cities) {
                ObjectDoubleMap<Point2D> hueristicForTarget = this.calculateHeuristicForSource(city.getCoordinates(), cities);
                this.heuristicMap.put(city.getCoordinates(), hueristicForTarget);
            }
            for (int x = 0; x < this.width; x += 5) {
                for (int y = 0; y < this.height; y += 5) {
                    Point2D source = this.getPoint(x, y);
                    ObjectDoubleMap<Point2D> hueristicForTarget = this.calculateHeuristicForSource(source, cities);
                    this.heuristicMap.put(source, hueristicForTarget);
                }
            }
        }
        long took = System.currentTimeMillis() - timestamp;
        this.logger.debug("Created heuristic for " + this.heuristicMap.size() + " sources connecting to " + this.heuristicMap.values().iterator().next().size() + " nodes taking " + took + "ms");
        this.clientServerEventBus.post((Object)new HeuristicGraphInitialisationComplete());
        this.initializing = false;
    }

    private ObjectDoubleMap<Point2D> calculateHeuristicForSource(Point2D source, List<ICity> cities) {
        ObjectDoubleScatterMap distance = new ObjectDoubleScatterMap();
        for (ICity city : cities) {
            Point2D coordinates = city.getCoordinates();
            double dist = this.calculateWeight(source, coordinates);
            distance.put((Object)coordinates, dist);
        }
        return distance;
    }

    @Override
    @VisibleForTesting
    protected double calculateWeight(Point2D from, Point2D to) {
        if (from.equals((Object)to)) {
            return 0.0;
        }
        double distance = from.distance(to);
        return distance;
    }

    public boolean heuristicForSourceAvailable(Point2D source) {
        return this.heuristicMap.containsKey(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Point2D, ObjectDoubleMap<Point2D>> getHeuristic() {
        Object object = this.lock;
        synchronized (object) {
            return this.heuristicMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetNodeToHeuristic(Point2D target) {
        Preconditions.checkNotNull((Object)target, (Object)"The target node may not be null");
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<Point2D, ObjectDoubleMap<Point2D>> entry : this.heuristicMap.entrySet()) {
                if (entry.getValue().containsKey((Object)target)) continue;
                Point2D source = entry.getKey();
                double dist = this.calculateWeight(source, target);
                entry.getValue().put((Object)target, dist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceNodeToHeuristic(Point2D source) {
        Preconditions.checkNotNull((Object)source, (Object)"The source node may not be null");
        if (!this.heuristicForSourceAvailable(source)) {
            Object object = this.lock;
            synchronized (object) {
                ObjectDoubleMap<Point2D> hueristicForTarget = this.calculateHeuristicForSource(source, this.map.getCities());
                this.heuristicMap.put(source, hueristicForTarget);
            }
        } else {
            this.logger.debug("Heuristic for source point {} is available (point is contained as key)", (Object)source);
        }
    }

    public Point2D findClosest(Point2D point) {
        double distance = Double.MAX_VALUE;
        Point2D p = null;
        for (Point2D tempPoint : this.getHeuristic().keySet()) {
            if (!(point.distance(tempPoint) < distance)) continue;
            distance = point.distance(tempPoint);
            p = tempPoint;
        }
        return p;
    }
}

