/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.HashMap;
import java.util.List;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DangerService {
    public int getNumberOfPirates(List<PirateActivityEntry> activities) {
        HashMap<ISeaPirate, Integer> counter = new HashMap<ISeaPirate, Integer>();
        for (PirateActivityEntry activity : activities) {
            ISeaPirate pirate = activity.getPirate();
            if (counter.containsKey(pirate)) {
                counter.put(pirate, (Integer)counter.get(pirate) + 1);
                continue;
            }
            counter.put(pirate, 1);
        }
        return counter.size();
    }

    public int getNumberOfPirateAttacks(List<PirateActivityEntry> activities) {
        return activities.size();
    }

    public int getNumberOfSuccessfulPirateAttacks(List<PirateActivityEntry> activities) {
        return (int)activities.stream().filter(attack -> attack.isFightWon()).filter(attack -> attack.getEnteredShips() > 0 || attack.getLootedShips() > 0 || attack.getSukenShips() > 0).count();
    }
}

