/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.sea.BlockadeSeafightContext;
import ch.sahits.game.openpatrician.engine.sea.ESeaFightType;
import ch.sahits.game.openpatrician.engine.sea.SeaFightContext;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivity;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.event.data.DisplayEventVideo;
import ch.sahits.game.openpatrician.event.data.ShipAttackEvent;
import ch.sahits.game.openpatrician.event.data.ShipDefenseEvent;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.event.EEventMediaType;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.people.impl.SeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.model.Tristate;
import ch.sahits.game.openpatrician.utilities.spring.DependentAnnotationConfigApplicationContext;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@DependentInitialisation(value=StartNewGameBean.class)
public class SeaFightService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @DependentValue(value="seafight.damage.per.strength")
    private double damagePerStrength = 2.0;
    @DependentValue(value="seafight.death.toll.per.damage")
    private double deathTollPerDamage = 0.2;
    @Autowired
    private ShipService shipStrenghtService;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private SeaPiratesState piratesState;
    @Autowired
    private DependentPropertyInitializer propertyInitializer;
    @Autowired
    private PlayerList players;
    @Autowired
    private PirateActivity pirateActivity;
    @Autowired
    private DialogTemplateFactory dialogTemplateFactory;

    @PostConstruct
    private void init() {
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Failed to initialize DependentValue annotated fields");
        }
    }

    public void calculateOutcome(INavigableVessel attackingVessel, INavigableVessel defendingVessel, SeaFightContext context) {
        List<IShip> attackingShips = this.explodeShipList(attackingVessel);
        List<IShip> defendingShips = this.explodeShipList(defendingVessel);
        List<GenericPair<List<IShip>, List<IShip>>> pairings = this.calculatePairing(attackingShips, defendingShips);
        ArrayList<IShip> sunkenDefendingShips = new ArrayList<IShip>();
        ArrayList<IShip> sunkenAttackingShips = new ArrayList<IShip>();
        ArrayList<IShip> capturedDefendingShips = new ArrayList<IShip>();
        ArrayList<IShip> capturedAttackingShips = new ArrayList<IShip>();
        IShipOwner attacker = attackingShips.get(0).getOwner();
        IShipOwner defender = defendingShips.get(0).getOwner();
        Iterator<GenericPair<List<IShip>, List<IShip>>> pairingIter = pairings.iterator();
        while (pairingIter.hasNext()) {
            GenericPair<List<IShip>, List<IShip>> pairing = pairingIter.next();
            boolean attackShipTurn = true;
            this.runAttackMove(pairings, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, pairingIter, pairing, attackShipTurn, context);
            if (pairings.size() <= 0) continue;
            attackShipTurn = false;
            this.runAttackMove(pairings, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, pairingIter, pairing, attackShipTurn, context);
        }
        Iterator iterator = capturedAttackingShips.iterator();
        while (iterator.hasNext()) {
            IShip ship = (IShip)iterator.next();
            if (!capturedDefendingShips.contains(ship)) continue;
            iterator.remove();
            capturedDefendingShips.remove(ship);
        }
        switch (context.getType()) {
            case STANDARD: {
                if (attackingVessel.getOwner() instanceof ISeaPirate) {
                    this.updatePirateAttackStatistic(defendingShips, sunkenDefendingShips, capturedDefendingShips, attacker);
                }
                this.postMessageStandardFight(attackingShips, defendingShips, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, attacker, defender);
                break;
            }
            case BLOCKADE: {
                this.postMessageBlockadeFight(attackingShips, defendingShips, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, attacker, defender);
                break;
            }
            default: {
                throw new RuntimeException("The post message for fight type " + (Object)((Object)context.getType()) + " is not implemented");
            }
        }
        if (context instanceof BlockadeSeafightContext) {
            for (IShip ship : capturedDefendingShips) {
                ((BlockadeSeafightContext)context).addCapturedShip(ship);
            }
        }
        ArrayList<IShip> defeatedDefendingShips = new ArrayList<IShip>(sunkenDefendingShips);
        defeatedDefendingShips.addAll(capturedDefendingShips);
        ArrayList<IShip> defeatedAttackingShips = new ArrayList<IShip>(sunkenAttackingShips);
        defeatedAttackingShips.addAll(capturedAttackingShips);
        this.updateCaptainsStats(attackingShips, defendingShips, defeatedDefendingShips, defeatedAttackingShips);
        this.postAttackOutcome(attackingShips, defendingShips, defeatedDefendingShips, defeatedAttackingShips, attackingVessel, defendingVessel);
    }

    @VisibleForTesting
    void updateCaptainsStats(List<IShip> attackingShips, List<IShip> defendingShips, List<IShip> defeatedDefendingShips, List<IShip> defeatedAttackingShips) {
        attackingShips.stream().filter(ship -> !defeatedAttackingShips.contains(ship)).filter(ship -> ship.getCaptian().isPresent()).forEach(ship -> this.updateFightingSkill((IShip)ship));
        defendingShips.stream().filter(ship -> !defeatedDefendingShips.contains(ship)).filter(ship -> ship.getCaptian().isPresent()).forEach(ship -> this.updateFightingSkill((IShip)ship));
    }

    private void updateFightingSkill(IShip ship) {
        ICaptain captain = (ICaptain)ship.getCaptian().get();
        ((ICaptain)ship.getCaptian().get()).updateFightWon();
        if (((ICaptain)ship.getCaptian().get()).upgradeToNextFightingLevel() && ship.getOwner() instanceof IHumanPlayer) {
            DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{((ICaptain)ship.getCaptian().get()).getName(), ship.getName(), captain.getSalary()});
            DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.CAPTAIN_UPGRADE, parameterSupplier);
            DisplayTemplateMessage message = new DisplayTemplateMessage("ch.sahits.game.openpatrician.model.people.impl.CaptainState.captainUpgrade.title", template, new Object[0]);
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)ship.getOwner(), (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
    }

    private void updatePirateAttackStatistic(List<IShip> defendingShips, List<IShip> sunkenDefendingShips, List<IShip> capturedDefendingShips, IShipOwner attacker) {
        boolean won = defendingShips.size() - capturedDefendingShips.size() - sunkenDefendingShips.size() <= 0;
        PirateActivityEntry entry = PirateActivityEntry.builder().pirate((ISeaPirate)attacker).enteredShips(capturedDefendingShips.size()).sukenShips(sunkenDefendingShips.size()).lootedShips(0).fightWon(won).build();
        this.pirateActivity.add(entry);
    }

    @VisibleForTesting
    void postAttackOutcome(List<IShip> attackingShips, List<IShip> defendingShips, List<IShip> defeatedDefendingShips, List<IShip> defeatedAttackingShips, INavigableVessel attackingVessel, INavigableVessel defendingVessel) {
        if (defendingShips.size() == defeatedDefendingShips.size()) {
            this.clientServerEventBus.post((Object)new ShipAttackEvent(defendingVessel, attackingVessel));
            if (attackingVessel.getPirateFlag()) {
                IShipOwner owner = attackingVessel.getOwner();
                String name = owner.getName() + " " + owner.getLastName();
                String titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.eventvideo.title";
                Object[] titleParams = new Object[]{};
                DisplayEventVideo event = DisplayEventVideo.builder().mediaType(EEventMediaType.PIRATE_ATTACK).durationInSeconds(23).titleKey(titleKey).titleParams(titleParams).descriptionKey("ch.sahits.game.openpatrician.engine.sea.SeaFightService.eventvideo.message").descriptionParams(new Object[]{name}).build();
                for (IPlayer player : this.players) {
                    if (!(player instanceof IHumanPlayer)) continue;
                    this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)event));
                }
            }
        }
        if (attackingShips.size() == defeatedAttackingShips.size()) {
            this.clientServerEventBus.post((Object)new ShipDefenseEvent(defendingVessel, attackingVessel));
        }
    }

    @VisibleForTesting
    void postMessageBlockadeFight(List<IShip> attackingShips, List<IShip> defendingShips, List<IShip> sunkenDefendingShips, List<IShip> sunkenAttackingShips, List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, IShipOwner attacker, IShipOwner defender) {
        ArrayList<IShip> lostShips = new ArrayList<IShip>();
        lostShips.addAll(sunkenAttackingShips);
        lostShips.addAll(capturedAttackingShips);
        ArrayListMultimap lostShipsPerPlayer = ArrayListMultimap.create();
        for (IShip lostShip : lostShips) {
            if (!(lostShip.getOwner() instanceof IHumanPlayer)) continue;
            lostShipsPerPlayer.put((Object)((IHumanPlayer)lostShip.getOwner()), (Object)lostShip);
        }
        for (IHumanPlayer player : lostShipsPerPlayer.keySet()) {
            ArrayList ships = new ArrayList(lostShipsPerPlayer.get((Object)player));
            String titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.blockade.attack.title";
            String messageKey = "";
            Object[] args = null;
            if (ships.size() == 1) {
                messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.blockade.attack.lostShip";
                args = new Object[]{((IShip)ships.get(0)).getName()};
            } else {
                messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.blockade.attack.lostShips";
                args = new Object[]{ships.size()};
            }
            DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            DisplayTemplateMessage message = new DisplayTemplateMessage(titleKey, template, new Object[0]);
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)attacker, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
        if (defender instanceof IHumanPlayer) {
            lostShips = new ArrayList();
            lostShips.addAll(sunkenDefendingShips);
            lostShips.addAll(capturedDefendingShips);
            String titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.blockade.defense.title";
            String messageKey = "";
            Object[] args = null;
            if (lostShips.size() == 1) {
                messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.blockade.defense.lostShip";
                args = new Object[]{((IShip)lostShips.get(0)).getName()};
            } else {
                messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.blockade.defense.lostShips";
                args = new Object[]{lostShips.size()};
            }
            DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            DisplayTemplateMessage message = new DisplayTemplateMessage(titleKey, template, new Object[0]);
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)defender, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
    }

    @VisibleForTesting
    void postMessageStandardFight(List<IShip> attackingShips, List<IShip> defendingShips, List<IShip> sunkenDefendingShips, List<IShip> sunkenAttackingShips, List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, IShipOwner attacker, IShipOwner defender) {
        TargetedEvent tagetDisplayMsg;
        DisplayTemplateMessage message;
        DialogTemplate template;
        String lostShipName;
        String lostShipName2;
        String lastShipcaptured;
        String lastShipcaptured2;
        StringBuffer capturedShips;
        String lastShipSunk;
        StringBuffer sunkenShips;
        String lastShip;
        StringBuffer capturedShips2;
        Tristate tristate;
        int lostShips;
        Object[] args;
        String messageKey;
        String titleKey;
        if (attacker instanceof IHumanPlayer) {
            titleKey = "";
            messageKey = "";
            args = null;
            lostShips = sunkenAttackingShips.size() + capturedAttackingShips.size();
            tristate = lostShips == 0 ? Tristate.STATE_TWO : (lostShips == attackingShips.size() ? Tristate.STATE_ONE : Tristate.STATE_THREE);
            switch (tristate) {
                case STATE_ONE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessfulAttackAttacker.title";
                    if (sunkenAttackingShips.size() == 1 && capturedAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneShip";
                        args = new Object[]{sunkenAttackingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 0 && capturedAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneShip";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 1 && capturedAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkAndCapturedOneShip";
                        args = new Object[]{sunkenAttackingShips.get(0).getName(), capturedAttackingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 1 && capturedAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShip = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{sunkenAttackingShips.get(0).getName(), capturedShips2.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 0 && capturedAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShip = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() > 1 && capturedAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenAttackingShips);
                        lastShip = sunkenAttackingShips.get(sunkenAttackingShips.size() - 1).getName();
                        args = new Object[]{sunkenShips.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() > 1 && capturedAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneAndSunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenAttackingShips);
                        lastShip = sunkenAttackingShips.get(sunkenAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedAttackingShips.get(0).getName(), sunkenShips.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleAndSunkMultipleShip";
                    sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenAttackingShips);
                    lastShipSunk = sunkenAttackingShips.get(sunkenAttackingShips.size() - 1).getName();
                    capturedShips = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                    lastShipcaptured2 = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                    args = new Object[]{capturedShips.toString(), lastShipcaptured2, sunkenShips.toString(), lastShipSunk, defender.getName() + " " + defender.getLastName()};
                    break;
                }
                case STATE_TWO: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successfulAttackAttacker.title";
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneShip";
                        args = new Object[]{defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneShip";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkAndCapturedOneShip";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkMultipleShip";
                        args = new Object[]{sunkenDefendingShips.size(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneAndSunkMultipleShip";
                        args = new Object[]{sunkenDefendingShips.size(), capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleAndSunkMultipleShip";
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                    lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                    args = new Object[]{sunkenDefendingShips.size(), capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName()};
                    break;
                }
                case STATE_THREE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successfulAttackAttackerLosses.title";
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShips";
                        args = new Object[]{defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 0) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShips";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShips";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{sunkenDefendingShips.size(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShips";
                        args = new Object[]{sunkenDefendingShips.size(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{sunkenDefendingShips.size(), capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShips";
                        args = new Object[]{sunkenDefendingShips.size(), capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 0) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 1) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                    lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                    if (lostShips == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShip";
                        lostShipName = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                        args = new Object[]{sunkenDefendingShips.size(), capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShipName};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShips";
                    args = new Object[]{sunkenDefendingShips.size(), capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShips};
                }
            }
            template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            message = new DisplayTemplateMessage(titleKey, template, new Object[0]);
            tagetDisplayMsg = new TargetedEvent((IHumanPlayer)attacker, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
        if (defender instanceof IHumanPlayer) {
            titleKey = "";
            messageKey = "";
            args = null;
            lostShips = sunkenDefendingShips.size() + capturedDefendingShips.size();
            tristate = lostShips == 0 ? Tristate.STATE_TWO : (lostShips == defendingShips.size() ? Tristate.STATE_ONE : Tristate.STATE_THREE);
            switch (tristate) {
                case STATE_ONE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successfulAttackDefender.title";
                    if (sunkenDefendingShips.size() == 1 && capturedDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneShip";
                        args = new Object[]{sunkenDefendingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 0 && capturedDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneShip";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 1 && capturedDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkAndCapturedOneShip";
                        args = new Object[]{sunkenDefendingShips.get(0).getName(), capturedDefendingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 1 && capturedDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShip = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{sunkenDefendingShips.get(0).getName(), capturedShips2.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 0 && capturedDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShip = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() > 1 && capturedDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenDefendingShips);
                        lastShip = sunkenDefendingShips.get(sunkenDefendingShips.size() - 1).getName();
                        args = new Object[]{sunkenShips.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() > 1 && capturedDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneAndSunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenDefendingShips);
                        lastShip = sunkenDefendingShips.get(sunkenDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedDefendingShips.get(0).getName(), sunkenShips.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleAndSunkMultipleShip";
                    sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenDefendingShips);
                    lastShipSunk = sunkenDefendingShips.get(sunkenDefendingShips.size() - 1).getName();
                    capturedShips = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                    lastShipcaptured2 = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                    args = new Object[]{capturedShips.toString(), lastShipcaptured2, sunkenShips.toString(), lastShipSunk, attacker.getName() + " " + attacker.getLastName()};
                    break;
                }
                case STATE_TWO: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessfulAttackDefender.title";
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneShip";
                        args = new Object[]{attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneShip";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkAndCapturedOneShip";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkMultipleShip";
                        args = new Object[]{sunkenAttackingShips.size(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneAndSunkMultipleShip";
                        args = new Object[]{sunkenAttackingShips.size(), capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleAndSunkMultipleShip";
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                    lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                    args = new Object[]{sunkenAttackingShips.size(), capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName()};
                    break;
                }
                case STATE_THREE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessfulAttackDefenderLosses.title";
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShips";
                        args = new Object[]{attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 0) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShips";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShips";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{sunkenAttackingShips.size(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShips";
                        args = new Object[]{sunkenAttackingShips.size(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{sunkenAttackingShips.size(), capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShips";
                        args = new Object[]{sunkenAttackingShips.size(), capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 0) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 1) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                    lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                    if (lostShips == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShip";
                        lostShipName = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                        args = new Object[]{sunkenAttackingShips.size(), capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShipName};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShips";
                    args = new Object[]{sunkenAttackingShips.size(), capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShips};
                }
            }
            template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            message = new DisplayTemplateMessage(titleKey, template, new Object[0]);
            tagetDisplayMsg = new TargetedEvent((IHumanPlayer)defender, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
    }

    @VisibleForTesting
    StringBuffer getShipNameListWithoutTheLastShip(List<IShip> shipList) {
        StringBuffer sunkenShips = new StringBuffer();
        for (int i = 0; i < shipList.size() - 1; ++i) {
            IShip ship = shipList.get(i);
            sunkenShips.append(ship.getName());
            if (i >= shipList.size() - 2) continue;
            sunkenShips.append(", ");
        }
        return sunkenShips;
    }

    private String getNameOfSingleLostShip(List<IShip> sunkenAttackingShips, List<IShip> capturedAttackingShips) {
        return capturedAttackingShips.size() == 1 ? capturedAttackingShips.get(0).getName() : sunkenAttackingShips.get(0).getName();
    }

    private void runAttackMove(List<GenericPair<List<IShip>, List<IShip>>> pairings, List<IShip> sunkenDefendingShips, List<IShip> sunkenAttackingShips, List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, Iterator<GenericPair<List<IShip>, List<IShip>>> pairingIter, GenericPair<List<IShip>, List<IShip>> pairing, boolean attackShipTurn, SeaFightContext context) {
        List shipsNotOnTurn;
        List shipsOnTurn;
        ESeaFightType fightType = context.getType();
        if (attackShipTurn) {
            shipsOnTurn = (List)pairing.getFirst();
            shipsNotOnTurn = (List)pairing.getSecond();
        } else {
            shipsOnTurn = (List)pairing.getSecond();
            shipsNotOnTurn = (List)pairing.getFirst();
        }
        int strength = this.calculateStrength(shipsOnTurn);
        int agilityOnTurn = this.calculateAgility(shipsOnTurn);
        int agilityNotOnTurn = this.calculateAgility(shipsNotOnTurn);
        double evasionProbability = this.calculateEvasionProbability(agilityOnTurn, agilityNotOnTurn);
        double accuracy = this.calculateAccuracy(shipsOnTurn);
        int damage = this.calculateDamage(strength, accuracy, evasionProbability);
        int damagePerShip = damage / shipsNotOnTurn.size();
        int damageFirstShip = damagePerShip + damage % shipsNotOnTurn.size();
        ((IShip)shipsNotOnTurn.get(0)).damage(damageFirstShip, true);
        for (int i = 1; i < shipsNotOnTurn.size(); ++i) {
            ((IShip)shipsNotOnTurn.get(i)).damage(damagePerShip, true);
        }
        Iterator iterator = shipsNotOnTurn.iterator();
        while (iterator.hasNext()) {
            IShip ship = (IShip)iterator.next();
            if (ship.getDamage() != 0) continue;
            if (attackShipTurn) {
                sunkenDefendingShips.add(ship);
            } else {
                sunkenAttackingShips.add(ship);
            }
            iterator.remove();
            this.removeFromFleet(ship, ship.getOwner());
        }
        if (shipsNotOnTurn.isEmpty()) {
            pairingIter.remove();
            if (pairings.size() > 0) {
                this.redistributeShips(pairings, attackShipTurn, shipsOnTurn);
            }
        } else {
            int deathToll = this.calculateDeathToll(shipsNotOnTurn, damage);
            int deathTollPerShip = deathToll / shipsNotOnTurn.size();
            int deathTollFirstShip = deathTollPerShip + deathToll % shipsNotOnTurn.size();
            ((IShip)shipsNotOnTurn.get(0)).setNumberOfSailors(((IShip)shipsNotOnTurn.get(0)).getNumberOfSailors() - deathTollFirstShip);
            for (int i = 1; i < shipsNotOnTurn.size(); ++i) {
                ((IShip)shipsNotOnTurn.get(i)).setNumberOfSailors(((IShip)shipsNotOnTurn.get(i)).getNumberOfSailors() - deathTollPerShip);
            }
            IShip shipWithMaxSailors = this.findMaxSailorsOnShip(shipsOnTurn);
            IShip captureShip = null;
            for (IShip ship : shipsNotOnTurn) {
                if (ship.getNumberOfSailors() + 5 >= shipWithMaxSailors.getNumberOfSailors()) continue;
                captureShip = ship;
                break;
            }
            this.updateCapturedShip(capturedDefendingShips, capturedAttackingShips, attackShipTurn, shipWithMaxSailors, captureShip, context);
            if (shipsNotOnTurn.isEmpty()) {
                pairingIter.remove();
                this.redistributeShips(pairings, attackShipTurn, shipsOnTurn);
            } else if (shipsOnTurn.isEmpty()) {
                pairingIter.remove();
                this.redistributeShips(pairings, !attackShipTurn, shipsNotOnTurn);
            }
        }
    }

    private void redistributeShips(List<GenericPair<List<IShip>, List<IShip>>> pairings, boolean attackShipTurn, List<IShip> survivingShips) {
        for (IShip ship : survivingShips) {
            GenericPair<List<IShip>, List<IShip>> weakestPairing = this.findWeakest(pairings, attackShipTurn);
            if (attackShipTurn) {
                ((List)weakestPairing.getFirst()).add(ship);
                continue;
            }
            ((List)weakestPairing.getSecond()).add(ship);
        }
    }

    @VisibleForTesting
    void updateCapturedShip(List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, boolean attackShipTurn, IShip shipWithMaxSailors, IShip captureShip, SeaFightContext context) {
        if (captureShip != null) {
            int calculateCaptureSailors = this.captureShip(shipWithMaxSailors, captureShip);
            if (calculateCaptureSailors < 0) {
                this.updateCapturedShipInternal(capturedDefendingShips, capturedAttackingShips, attackShipTurn, shipWithMaxSailors, captureShip, context);
            } else {
                this.updateCapturedShipInternal(capturedAttackingShips, capturedDefendingShips, attackShipTurn, captureShip, shipWithMaxSailors, context);
            }
        }
    }

    private void updateCapturedShipInternal(List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, boolean attackShipTurn, IShip shipWithMaxSailors, IShip captureShip, SeaFightContext context) {
        int numberOfSailors = captureShip.getNumberOfSailors();
        int halfTheSailors = numberOfSailors / 2;
        captureShip.setNumberOfSailors(numberOfSailors - halfTheSailors);
        IShipOwner previousOwner = shipWithMaxSailors.getOwner();
        this.removeFromFleet(shipWithMaxSailors, previousOwner);
        shipWithMaxSailors.setNumberOfSailors(halfTheSailors);
        shipWithMaxSailors.setOwner(captureShip.getOwner());
        if (context.getType() == ESeaFightType.BLOCKADE && attackShipTurn) {
            IBlockade blockade = ((BlockadeSeafightContext)context).getBlockade();
            blockade.getShipsToAuction().add(captureShip);
        } else {
            this.addToFleet(shipWithMaxSailors, captureShip.getOwner());
        }
        if (attackShipTurn) {
            capturedAttackingShips.add(shipWithMaxSailors);
        } else {
            capturedDefendingShips.add(shipWithMaxSailors);
        }
    }

    @VisibleForTesting
    void addToFleet(IShip ship, IShipOwner owner) {
        if (owner instanceof IPlayer) {
            ((IPlayer)owner).getFleet().add(ship);
        }
        if (owner instanceof ISeaPirate) {
            IShipGroup oldGroup;
            ISeaPirate pirate = (ISeaPirate)owner;
            IShipGroup iShipGroup = oldGroup = pirate.getShip() instanceof IShipGroup ? (IShipGroup)pirate.getShip() : null;
            if (oldGroup != null) {
                oldGroup.addShip(ship);
            } else {
                ArrayList<IShip> ships = new ArrayList<IShip>();
                ships.add((IShip)pirate.getShip());
                ships.add(ship);
                IShipGroup group = this.regroup(ships, (IShipGroup)null);
                ((SeaPirate)pirate).setShip((INavigableVessel)group);
            }
        }
    }

    @VisibleForTesting
    void removeFromFleet(IShip ship, IShipOwner owner) {
        if (owner instanceof IPlayer) {
            ((IPlayer)owner).getFleet().remove(ship);
        }
        if (owner instanceof ISeaPirate) {
            IShipGroup oldGroup;
            ISeaPirate pirate = (ISeaPirate)owner;
            IShipGroup iShipGroup = oldGroup = pirate.getShip() instanceof IShipGroup ? (IShipGroup)pirate.getShip() : null;
            if (oldGroup != null) {
                oldGroup.removeShip(ship);
                if (oldGroup.getShips().size() == 1) {
                    ((SeaPirate)pirate).setShip((INavigableVessel)oldGroup.getShips().get(0));
                    ((DependentAnnotationConfigApplicationContext)this.context).removePrototypeBean((Object)oldGroup);
                }
            } else {
                this.piratesState.remove(pirate);
                ((DependentAnnotationConfigApplicationContext)this.context).removePrototypeBean((Object)pirate);
            }
        }
    }

    @VisibleForTesting
    int captureShip(IShip attackingShip, IShip defendingShip) {
        int attackingHandWeapon = attackingShip.getWeaponAmount((IWeapon)EWeapon.HAND_WEAPON);
        int defendingHandWeapon = defendingShip.getWeaponAmount((IWeapon)EWeapon.HAND_WEAPON);
        while (attackingShip.getNumberOfSailors() > 0 && defendingShip.getNumberOfSailors() > 0) {
            int nbSailors;
            int attackForce = attackingShip.getNumberOfSailors() + attackingHandWeapon;
            int defendForce = defendingShip.getNumberOfSailors() + defendingHandWeapon;
            double propSurvivingAttack = this.calculatePropSurvivingAttack(attackingShip, defendingShip);
            if (propSurvivingAttack > 0.8) {
                if (attackForce > defendForce) {
                    nbSailors = attackingShip.getNumberOfSailors() - 1;
                    attackingShip.setNumberOfSailors(nbSailors);
                    continue;
                }
                nbSailors = defendingShip.getNumberOfSailors() - 1;
                defendingShip.setNumberOfSailors(nbSailors);
                continue;
            }
            if (propSurvivingAttack > 0.5) continue;
            if (attackForce > defendForce) {
                nbSailors = defendingShip.getNumberOfSailors() - 1;
                defendingShip.setNumberOfSailors(nbSailors);
                continue;
            }
            nbSailors = attackingShip.getNumberOfSailors() - 1;
            attackingShip.setNumberOfSailors(nbSailors);
        }
        if (attackingShip.getNumberOfSailors() > 0) {
            return attackingShip.getNumberOfSailors();
        }
        return -defendingShip.getNumberOfSailors();
    }

    @VisibleForTesting
    double calculatePropSurvivingAttack(IShip attackingShip, IShip defendingShip) {
        double captainCapabilities = 1.0;
        if (attackingShip.getCaptian().isPresent()) {
            captainCapabilities -= (double)((ICaptain)attackingShip.getCaptian().get()).getFightSkillLevel() * 0.1;
        }
        if (defendingShip.getCaptian().isPresent()) {
            captainCapabilities += (double)((ICaptain)defendingShip.getCaptian().get()).getFightSkillLevel() * 0.1;
        }
        return Math.min(Math.abs(this.rnd.nextGaussian()) * captainCapabilities, 1.0);
    }

    @VisibleForTesting
    IShip findMaxSailorsOnShip(List<IShip> ships) {
        int maxSailors = ships.get(0).getNumberOfSailors();
        IShip maxSailorShip = ships.get(0);
        for (int i = 1; i < ships.size(); ++i) {
            if (ships.get(i).getNumberOfSailors() <= maxSailors) continue;
            maxSailorShip = ships.get(i);
            maxSailors = ships.get(i).getNumberOfSailors();
        }
        return maxSailorShip;
    }

    @VisibleForTesting
    int calculateDeathToll(List<IShip> shipsNotOnTurn, int damage) {
        double nbDeath = (double)damage * this.deathTollPerDamage * (this.rnd.nextGaussian() + 1.0);
        int totalSailors = 0;
        for (IShip ship : shipsNotOnTurn) {
            totalSailors += ship.getNumberOfSailors();
        }
        return (int)Math.rint(Math.min((double)totalSailors, nbDeath));
    }

    @VisibleForTesting
    int calculateDamage(int strength, double accuracy, double evasionProbability) {
        double possibleDamage = (double)strength * this.damagePerStrength;
        double damage = possibleDamage * accuracy;
        double evasion = this.rnd.nextDouble();
        if (evasion < evasionProbability) {
            return 0;
        }
        return (int)Math.rint(damage * evasionProbability * 1.5);
    }

    @VisibleForTesting
    double calculateAccuracy(List<IShip> shipsOnTurn) {
        double accuracy = 0.7;
        double captainAccuracy = 0.0;
        int nbCaptains = 0;
        for (IShip ship : shipsOnTurn) {
            if (!ship.getCaptian().isPresent()) continue;
            ++nbCaptains;
            captainAccuracy += (double)((ICaptain)ship.getCaptian().get()).getFightSkillLevel();
        }
        if (nbCaptains > 0) {
            captainAccuracy /= (double)nbCaptains * 10.0;
        }
        return accuracy + captainAccuracy;
    }

    @VisibleForTesting
    double calculateEvasionProbability(int attackingAgility, int defendingAgility) {
        if (defendingAgility < attackingAgility) {
            return 0.0;
        }
        if (defendingAgility == attackingAgility) {
            return 0.2;
        }
        return (double)(defendingAgility - attackingAgility) / 12.0 + 0.2;
    }

    private int calculateAgility(List<IShip> ships) {
        int agility = 0;
        for (IShip ship : ships) {
            agility += this.calculateAgility(ship);
        }
        return agility;
    }

    @VisibleForTesting
    int calculateAgility(IShip ship) {
        int agility = this.shipFactory.getShipSpeed(ship.getShipType());
        if (ship.getCaptian().isPresent()) {
            ICaptain captain = (ICaptain)ship.getCaptian().get();
            agility += (int)Math.rint((double)captain.getNavigationSkillLevel() * 0.7);
        }
        return agility;
    }

    @VisibleForTesting
    List<GenericPair<List<IShip>, List<IShip>>> calculatePairing(List<IShip> attackingShips, List<IShip> defendingShips) {
        int i;
        ArrayList<GenericPair<List<IShip>, List<IShip>>> pairings = new ArrayList<GenericPair<List<IShip>, List<IShip>>>();
        if (attackingShips.size() == defendingShips.size()) {
            for (int i2 = 0; i2 < attackingShips.size(); ++i2) {
                this.addPairing(attackingShips, defendingShips, pairings, i2);
            }
            return pairings;
        }
        int minSize = Math.min(attackingShips.size(), defendingShips.size());
        for (i = 0; i < minSize; ++i) {
            this.addPairing(attackingShips, defendingShips, pairings, i);
        }
        if (attackingShips.size() < defendingShips.size()) {
            for (i = minSize; i < defendingShips.size(); ++i) {
                GenericPair<List<IShip>, List<IShip>> weakestDefendingPair = this.findWeakest(pairings, false);
                ((List)weakestDefendingPair.getSecond()).add(defendingShips.get(i));
            }
        } else {
            for (i = minSize; i < attackingShips.size(); ++i) {
                GenericPair<List<IShip>, List<IShip>> weakestDefendingPair = this.findWeakest(pairings, true);
                ((List)weakestDefendingPair.getFirst()).add(attackingShips.get(i));
            }
        }
        return pairings;
    }

    @VisibleForTesting
    GenericPair<List<IShip>, List<IShip>> findWeakest(List<GenericPair<List<IShip>, List<IShip>>> parings, boolean lookInAttackingShips) {
        int minStrength = Integer.MAX_VALUE;
        int minStrengthIndex = 0;
        for (int i = 0; i < parings.size(); ++i) {
            GenericPair<List<IShip>, List<IShip>> paring = parings.get(i);
            List ships = lookInAttackingShips ? (List)paring.getFirst() : (List)paring.getSecond();
            int strength = 0;
            for (IShip ship : ships) {
                strength += this.calculateShipStrength(ship);
            }
            if (strength >= minStrength) continue;
            minStrength = strength;
            minStrengthIndex = i;
        }
        return parings.get(minStrengthIndex);
    }

    private int calculateStrength(List<IShip> ships) {
        int strength = 0;
        for (IShip ship : ships) {
            strength += this.calculateShipStrength(ship);
        }
        return strength;
    }

    @VisibleForTesting
    int calculateShipStrength(IShip ship) {
        int strength = this.shipStrenghtService.calculateShipsWeaponsStrength((INavigableVessel)ship);
        if (ship.getCaptian().isPresent()) {
            ICaptain captain = (ICaptain)ship.getCaptian().get();
            strength += captain.getFightSkillLevel() * 2;
        }
        return strength;
    }

    private void addPairing(List<IShip> attackingShips, List<IShip> defendingShips, List<GenericPair<List<IShip>, List<IShip>>> pairings, int i) {
        ArrayList<IShip> attackingShip = new ArrayList<IShip>();
        attackingShip.add(attackingShips.get(i));
        ArrayList<IShip> defending = new ArrayList<IShip>();
        defending.add(defendingShips.get(i));
        GenericPair pair = new GenericPair(attackingShip, defending);
        pairings.add((GenericPair<List<IShip>, List<IShip>>)pair);
    }

    private List<IShip> explodeShipList(IConvoy convoy) {
        return new ArrayList<IShip>(convoy.getShips());
    }

    public List<IShip> explodeShipList(INavigableVessel vessel) {
        if (vessel instanceof IConvoy) {
            return this.explodeShipList((IConvoy)vessel);
        }
        if (vessel instanceof IShipGroup) {
            return this.explodeShipList((IShipGroup)vessel);
        }
        return this.explodeShipList((IShip)vessel);
    }

    private List<IShip> explodeShipList(IShipGroup group) {
        return new ArrayList<IShip>(group.getShips());
    }

    private List<IShip> explodeShipList(IShip ship) {
        ArrayList<IShip> ships = new ArrayList<IShip>();
        ships.add(ship);
        return ships;
    }

    public IShipGroup regroup(List<IShip> ships, IShipGroup oldGroup) {
        IShipGroup newGroup = oldGroup;
        if (newGroup == null) {
            newGroup = (IShipGroup)this.context.getBean("shipGroup", new Object[]{ships.get(0)});
            for (int i = 1; i < ships.size(); ++i) {
                newGroup.addShip(ships.get(i));
            }
        } else {
            for (int i = 0; i < ships.size(); ++i) {
                newGroup.addShip(ships.get(i));
            }
        }
        return newGroup;
    }

    public IConvoy regroup(List<IShip> ships, IConvoy oldConvoy) {
        IConvoy newGroup = oldConvoy;
        if (newGroup == null) {
            newGroup = (IConvoy)this.context.getBean("convoy", new Object[]{ships.get(0), false});
            for (int i = 1; i < ships.size(); ++i) {
                newGroup.addShip(ships.get(i));
            }
        } else {
            for (int i = 0; i < ships.size(); ++i) {
                newGroup.addShip(ships.get(i));
            }
        }
        return newGroup;
    }
}

